<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRedis;

class BackupCollection extends \Google\Model
{
  /**
   * @var string
   */
  public $cluster;
  /**
   * @var string
   */
  public $clusterUid;
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $kmsKey;
  /**
   * @var string
   */
  public $lastBackupTime;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $totalBackupCount;
  /**
   * @var string
   */
  public $totalBackupSizeBytes;
  /**
   * @var string
   */
  public $uid;

  /**
   * @param string
   */
  public function setCluster($cluster)
  {
    $this->cluster = $cluster;
  }
  /**
   * @return string
   */
  public function getCluster()
  {
    return $this->cluster;
  }
  /**
   * @param string
   */
  public function setClusterUid($clusterUid)
  {
    $this->clusterUid = $clusterUid;
  }
  /**
   * @return string
   */
  public function getClusterUid()
  {
    return $this->clusterUid;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setKmsKey($kmsKey)
  {
    $this->kmsKey = $kmsKey;
  }
  /**
   * @return string
   */
  public function getKmsKey()
  {
    return $this->kmsKey;
  }
  /**
   * @param string
   */
  public function setLastBackupTime($lastBackupTime)
  {
    $this->lastBackupTime = $lastBackupTime;
  }
  /**
   * @return string
   */
  public function getLastBackupTime()
  {
    return $this->lastBackupTime;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setTotalBackupCount($totalBackupCount)
  {
    $this->totalBackupCount = $totalBackupCount;
  }
  /**
   * @return string
   */
  public function getTotalBackupCount()
  {
    return $this->totalBackupCount;
  }
  /**
   * @param string
   */
  public function setTotalBackupSizeBytes($totalBackupSizeBytes)
  {
    $this->totalBackupSizeBytes = $totalBackupSizeBytes;
  }
  /**
   * @return string
   */
  public function getTotalBackupSizeBytes()
  {
    return $this->totalBackupSizeBytes;
  }
  /**
   * @param string
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BackupCollection::class, 'Google_Service_CloudRedis_BackupCollection');
