<?php


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'db.php';

    // Sanitize input
    $id     = $_POST['id'];
    $lrn    = trim(strtoupper($_POST['lrn']));
    $ln     = trim(strtoupper($_POST['lname']));
    $fn     = trim(strtoupper($_POST['fname']));
    $mn     = trim(strtoupper($_POST['mname']));
    $gender = trim(strtoupper($_POST['gender']));
    $bp     = trim(strtoupper($_POST['bp']));
    $dob    = $_POST['dob'];
    $address= trim(strtoupper($_POST['address']));
    $pg     = trim(strtoupper($_POST['pg']));
    $pga    = trim(strtoupper($_POST['pga']));
    $icc    = trim(strtoupper($_POST['icc']));
    $sy     = $_POST['sy'];
    $tny    = $_POST['tny'];
    $ave    = $_POST['ave'];
    $prog   = $_POST['prog'];
    $user   = $_SESSION['ID'];

    // Check for duplicate LRN
    $check_sql = "SELECT 1 FROM student_info WHERE LRN_NO = ? AND STUDENT_ID != ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("si", $lrn, $id);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $alert = 
        "<script>
        showAlert('warning', 'Notice', 'Student ID no. is not available. Already Exists');
        setTimeout(() => window.location.href = 'student_list.php', 4000);
        </script>";
    }
    $stmt->close();

    // Update student info
    $update_sql = "
        UPDATE student_info SET
            LRN_NO = ?,
            LASTNAME = ?,
            FIRSTNAME = ?,
            MIDDLENAME = ?,
            BIRTH_PLACE = ?,
            DATE_OF_BIRTH = ?,
            ADDRESS = ?,
            GENDER = ?,
            PARENT_GUARDIAN = ?,
            P_ADDRESS = ?,
            INT_COURSE_COMP = ?,
            SCHOOL_YEAR = ?,
            TOTAL_NO_OF_YEARS = ?,
            GEN_AVE = ?,
            PROGRAM = ?
        WHERE STUDENT_ID = ?
    ";
    $stmt = $conn->prepare($update_sql);
    $stmt->bind_param("sssssssssssssssi", 
        $lrn, $ln, $fn, $mn, $bp, $dob, $address, $gender, $pg, $pga, 
        $icc, $sy, $tny, $ave, $prog, $id
    );

    if ($stmt->execute()) {
        // Log the update
        $log_sql = "INSERT INTO history_log (transaction, user_id, date_added) VALUES (?, ?, NOW())";
        $log_stmt = $conn->prepare($log_sql);
        $log_msg = "Updated student ID $id";
        $log_stmt->bind_param("si", $log_msg, $user);
        $log_stmt->execute();
        $log_stmt->close();

        // Show success message
        $alert = 
        "<script>
        showAlert('success', 'Updated!', 'Successfully Updated');
        setTimeout(() => window.location.href = 'student_list.php', 2000);
        </script>";
    } else {
           $alert = "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    showAlert('error', 'Error!', 'Failed to perform this action');
                    setTimeout(() => window.location.href = 'student_list.php', 3000);
                });
            </script>";
    }

    $stmt->close();
    $conn->close();
}
?>