<?php 
session_start(); 
if (!isset($_SESSION['ID'])) {
    header('location: login.php');
    exit();
} else {

    include 'db.php'; // Make sure $conn is a MySQLi connection

    if (isset($_GET['Id']) && isset($_GET['stat'])) {
        $id = $_GET['Id'];
        $stat = $_GET['stat'];

        // Prepare the statement
        $stmt = mysqli_prepare($conn, "UPDATE user SET STATUS = ? WHERE USER_ID = ?");
        if ($stmt) {
            // Bind parameters (both are strings here, change type if needed)
            mysqli_stmt_bind_param($stmt, "ss", $stat, $id);

            // Execute the statement
            if (mysqli_stmt_execute($stmt)) {
                header('location: faculty.php');
                exit();
            } else {
                echo "<br><div class='warning'><strong>ERROR FOUND: " . mysqli_stmt_error($stmt) . " <a href='faculty.php'> Go Back to Faculty List. </a></strong></div>";
            }

            mysqli_stmt_close($stmt);
        } else {
            echo "<br><div class='warning'><strong>ERROR FOUND: " . mysqli_error($conn) . " <a href='index.php'> Go Back to Home. </a></strong></div>";
        }
    }

    mysqli_close($conn);
    header('location: faculty.php');
    exit();
}
?>
