<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('includes/header.php'); ?>
    <!-- Favicon icon -->
    <?php include('includes/stylesheets.php'); ?>
    <script type="text/javascript" src="assets/pages/notification/notification.js"></script>
</head>

<body>
    <?php include('includes/loader.php'); ?>
    <div id="pcoded" class="pcoded">
        <div class="pcoded-overlay-box"></div>
        <div class="pcoded-container navbar-wrapper">

            <?php include('includes/topnavbar.php'); ?>
            <div class="pcoded-main-container">
                <div class="pcoded-wrapper">
                    <?php
                    include 'db.php';

                    $sql = mysqli_query($conn, "SELECT * FROM user where USER_ID = '" . $_SESSION['ID'] . "'");
                    $row = mysqli_fetch_assoc($sql);
                    $accesstype = $row['USER_TYPE'] ?? 'Staff';
                        if ($accesstype == 'ADMINISTRATOR') {
                            include 'includes/sidebar.php';
                        } else {
                            include 'includes/sidebar_faculty.php';
                        }
                    ?>

                    <div class="pcoded-content">
                        <!-- Page-header start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">Academics</h5>
                                            <p class="m-b-0">Explore the subjects, programs, and curriculum offered by
                                                the institution.</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item">
                                                <a href="index.html"> <i class="fa fa-home"></i> </a>
                                            </li>
                                            <li class="breadcrumb-item"><a href="#!">Subject List</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Page-header end -->

                        <div class="pcoded-inner-content">
                            <!-- Main-body start -->
                            <div class="main-body">
                                <div class="page-wrapper">
                                    <!-- Page body start -->
                                    <div class="page-body">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>List of Subjects</h5>
                                                        <!--<span>Add class of <code>.form-control</code> with <code>&lt;input&gt;</code> tag</span>-->
                                                        <?php
                                                        include 'subject_list_exe.php';


                                                        ?>
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="table-responsive">



                                                            <div class="panel panel-default">
                                                                <div class="panel-heading">
                                                                    <!--<h3 class="panel-title"></h3>-->
                                                                </div>
                                                                <div class="panel-body">
                                                                    <table id="students"
                                                                        class="table table-hover table-bordered">
                                                                        <thead>
                                                                            <tr>
                                                                                <th style=" display:none;">ID
                                                                                </th>
                                                                                <th style="width:15% !important">Subject
                                                                                    Code</th>
                                                                                <th style="width:45% !important">
                                                                                    Subject Title</th>
                                                                                <th style="width:10% !important">Year
                                                                                    Level</th>
                                                                                <th style="width:10% !important">
                                                                                    Semester</th>
                                                                                <th style="width:5% !important">Program
                                                                                </th>
                                                                                <th style="width:15% !important">Action
                                                                                </th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php

                                                                            include 'db.php';
                                                                            $sql = mysqli_query($conn, "SELECT * FROM subjects");

                                                                            if ($sql) {
                                                                                while ($row = mysqli_fetch_assoc($sql)) {
                                                                                    ?>
                                                                                    <tr>
                                                                                        <!-- Hidden ID -->
                                                                                        <td style="display:none;">
                                                                                            <input type="hidden"
                                                                                                id="id<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="id[]"
                                                                                                value="<?php echo htmlspecialchars($row['SUBJECT_ID']); ?>">
                                                                                        </td>

                                                                                        <!-- Subject -->
                                                                                        <td>
                                                                                            <input type="hidden"
                                                                                                id="sub<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="subj"
                                                                                                style="background-color:transparent; border:0;"
                                                                                                value="<?php echo htmlspecialchars($row['SUBJECT_CODE']); ?>"
                                                                                                readonly>
                                                                                            <?php echo htmlspecialchars($row['SUBJECT_CODE']); ?>
                                                                                        </td>

                                                                                        <!-- Description -->
                                                                                        <td>
                                                                                            <input type="hidden"
                                                                                                id="desc<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="desc[]"
                                                                                                style="background-color:transparent; border:0; width:100%;"
                                                                                                value="<?php echo htmlspecialchars($row['DESCRIPTION']); ?>"
                                                                                                readonly>
                                                                                            <?php echo htmlspecialchars($row['DESCRIPTION']); ?>
                                                                                        </td>

                                                                                        <td>
                                                                                             <input type="hidden"
                                                                                                id="yrlevel<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="yrlevel[]"
                                                                                                style="background-color:transparent; border:0; width:100%;"
                                                                                                value="<?php echo htmlspecialchars($row['YEAR_LEVEL']); ?>"
                                                                                                readonly>
                                                                                            <?php echo htmlspecialchars($row['YEAR_LEVEL']); ?>
                                                                                        </td>

                                                                                        <td>
                                                                                             <input type="hidden"
                                                                                                id="sem<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="sem[]"
                                                                                                style="background-color:transparent; border:0; width:100%;"
                                                                                                value="<?php echo htmlspecialchars($row['SEMESTER']); ?>"
                                                                                                readonly>
                                                                                            <?php echo htmlspecialchars($row['SEMESTER']).' SEM'; ?>
                                                                                        
                                                                                       
                                                                                             <input type="hidden"
                                                                                                id="units<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                name="units[]"
                                                                                                style="background-color:transparent; border:0; width:100%;"
                                                                                                value="<?php echo htmlspecialchars($row['UNITS']); ?>"
                                                                                                readonly>
                                                                                        
                                                                                        
                                                                                         
                                                                                        
                                                                                        <td>
                                                                                            <?php
                                                                                            include 'db.php';
                                                                                            $prog_id = $row['PROGRAM_ID'];
                                                                                            $stmt = mysqli_query($conn, "SELECT *
                                                                                            from program where PROGRAM_ID=$prog_id");
                                                                                            while (
                                                                                                $array =
                                                                                                mysqli_fetch_assoc($stmt)
                                                                                            ) {
                                                                                                ?>
                                                                                                <input type="hidden"
                                                                                                    id="prog<?php echo $row['SUBJECT_ID']; ?>"
                                                                                                    name="prog[]"
                                                                                                    style="background-color:transparent; border:0; width:100%;"
                                                                                                    value="<?php echo htmlspecialchars($array['PROGRAM_ID']); ?>"
                                                                                                    readonly>
                                                                                                <?php echo htmlspecialchars($array['PROGRAM']); ?>
                                                                                            <?php } ?>
                                                                                        </td>

                                                                                        <!-- Edit button -->
                                                                                        <td>
                                                                                            <a onclick="update_subject(<?php echo $row['SUBJECT_ID']; ?>)"
                                                                                                class="badge btn-info text-white">
                                                                                                <i class="fa fa-pencil"
                                                                                                    aria-hidden="true"></i> edit
                                                                                            </a>
                                                                                        </td>
                                                                                    </tr>
                                                                                    <?php
                                                                                }
                                                                            } else {
                                                                                echo "<tr><td colspan='6'>Failed to fetch subjects. Error: " . mysqli_error($conn) . "</td></tr>";
                                                                            }


                                                                            mysqli_close($conn);
                                                                            ?>


                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <script>
                                                            function update_subject($i) {
                                                                var sub, sem, prog, desc, yrlevel, i = $i;
                                                                $("#id").val($("#id" + i).val());
                                                                $("#sub").val($("#sub" + i).val());
                                                                $("#sem").val($("#sem" + i).val());
                                                                $("#desc").val($("#desc" + i).val());
                                                                $("#units").val($("#units" + i).val());
                                                                $("#yrlevel").val($("#yrlevel" + i).val());
                                                                $("#head").html("Update Subject");
                                                                $("#btn_add").html("Update");
                                                            }
                                                        </script>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>Add New Subject</h5>
                                                        <!--<span>Add class of <code>.form-control</code> with <code>&lt;input&gt;</code> tag</span>-->
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="container frm-new">
                                                            <div class="row main">
                                                                <div class="main-login main-center">
                                                                    <!--<h3 id="head"></h3>-->
                                                                    <form class="" method="post">
                                                                        <input type="hidden" id="id" name="id">
                                                                        <div class="form-group">
                                                                            <label for="sub"
                                                                                class="cols-sm-2 control-label">Subject Code</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <span
                                                                                        class="input-group-addon"></span>
                                                                                    <input type="text"
                                                                                        class="form-control" name="sub"
                                                                                        id="sub"
                                                                                        placeholder="Enter Subject"
                                                                                        value="<?php if (isset($_POST['sub'])) {
                                                                                            echo htmlspecialchars($_POST['sub']);
                                                                                        } ?>" />
                                                                                </div>
                                                                                <p>
                                                                                    <?php if (isset($errors['sub'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['sub'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="sem"
                                                                                class="cols-sm-2 control-label">Semester</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <span
                                                                                        class="input-group-addon"></span>
                                                                                    <select id="sem" name="sem"
                                                                                        style="background-color:transparent; border:0; width:100%;">
                                                                                        <?php if (isset($_POST['sem'])) {
                                                                                            $sem = $_POST['sem']; ?>
                                                                                            <option
                                                                                                value="<?php echo htmlspecialchars($sem); ?>">
                                                                                                <?php echo htmlspecialchars($sem); ?>
                                                                                                Sem - Current
                                                                                            </option>
                                                                                        <?php } ?>
                                                                                        <option value="First">First Sem
                                                                                        </option>
                                                                                        <option value="Second">Second
                                                                                            Sem</option>
                                                                                    </select>
                                                                                </div>
                                                                                <p>
                                                                                    <?php if (isset($errors['sem'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['sem'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="yrlevel"
                                                                                class="cols-sm-2 control-label">Year
                                                                                Level</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <span
                                                                                        class="input-group-addon"></span>
                                                                                    <select id="yrlevel" name="yrlevel"
                                                                                        style="background-color:transparent; border:0; width:100%;">
                                                                                        <?php if (isset($_POST['yrlevel'])) {
                                                                                            $yrlevel = $_POST['yrlevel']; ?>
                                                                                            <option
                                                                                                value="<?php echo htmlspecialchars($yrlevel); ?>">
                                                                                                <?php echo htmlspecialchars($yrlevel); ?>
                                                                                                - Current
                                                                                            </option>
                                                                                        <?php } ?>
                                                                                        <option value="1st Year">1st
                                                                                            Year</option>
                                                                                        <option value="2nd Year">2nd
                                                                                            Year</option>
                                                                                        <option value="3rd Year">3rd
                                                                                            Year</option>
                                                                                        <option value="4th Year">4th
                                                                                            Year</option>
                                                                                    </select>
                                                                                </div>
                                                                                  <p>
                                                                                    <?php if (isset($errors['yrlevel'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['yrlevel'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="prog"
                                                                                class="cols-sm-2 control-label">Program</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <select name="prog"
                                                                                        class="form-control" id="prog"
                                                                                        required>
                                                                                        <option value="">- Select Program -
                                                                                        </option>
                                                                                        <?php
                                                                                        include 'db.php';
                                                                                        $sql = mysqli_query($conn, "SELECT * from program ORDER BY PROGRAM");
                                                                                        while ($row = mysqli_fetch_assoc($sql)) {
                                                                                            ?>
                                                                                           
                                                                                            <option
                                                                                                value="<?php echo $row['PROGRAM_ID'] ?>">
                                                                                                <?php echo $row['PROGRAM'] ?>
                                                                                            </option>
                                                                                        <?php }
                                                                                        mysqli_close($conn); ?>
                                                                                    </select>
                                                                                </div>
                                                                                  <p>
                                                                                    <?php if (isset($errors['prog'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['prog'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>

                                                                        <div class="form-group">
                                                                            <label for="desc"
                                                                                class="cols-sm-2 control-label">Subject Title</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <textarea type="text"
                                                                                        class="form-control" name="desc"
                                                                                        id="desc"
                                                                                        placeholder="Enter Description"
                                                                                        value="<?php if (isset($_POST['des'])) {
                                                                                            echo $_POST['desc'];
                                                                                        } ?>"></textarea>
                                                                                </div>
                                                                                <p>
                                                                                    <?php if (isset($errors['desc'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['desc'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="form-group">
                                                                            <label for="units"
                                                                                class="cols-sm-2 control-label">Units</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <input type="number"
                                                                                        class="form-control" name="units"
                                                                                        id="units"
                                                                                        placeholder="Enter Units"
                                                                                        value="<?php if (isset($_POST['units'])) {
                                                                                            echo htmlspecialchars($_POST['units']);
                                                                                        } ?>" />
                                                                                </div>
                                                                                  <p>
                                                                                    <?php if (isset($errors['units'])) {
                                                                                        echo "<div class='erlert'><h6>" . $errors['units'] . "</h6></div>";
                                                                                    } ?>
                                                                                </p>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                       <div class="form-group">
                                                                          <label for="units" class="cols-sm-2 control-label">Pre/Co-requisite</label>
                                                                          <div class="cols-sm-4">
                                                                            <div class="input-group">
                                                                              <select class="form-control" id="option-requisite" onchange="handleSelectChange()">
                                                                                <option value="">- Add Pre/Co-requisite -</option>
                                                                              </select>
                                                                            </div>
                                                                          </div>
                                                                        
                                                                          <!-- Hidden input field -->
                                                                          <input type="text" id="input-requisite" class="form-control" 
                                                                                 name="requisite" placeholder="Please specify here..." 
                                                                                 style="display:none;">
                                                                        </div>


                                                                         <div class="form-group">
                                                                          <label class="cols-sm-2 control-label" for="no-duplicates">
                                                                            <div class="cols-sm-4">
                                                                            <div class="input-group">
                                                                            <input type="checkbox" value="yes" id="no-duplicates" name="no-duplicates" class="form-control" checked> 
                                                                              <span style="margin-right: 5px"></span>No duplication of Subject code
                                                                             </div>
                                                                             </div>
                                                                          </label>
                                                                        </div>
                                                                       
                                                                                 
                                                                        <div class="form-group ">
                                                                            <input type="reset" class="btn btn-danger "
                                                                                id="reset" name="reset" value="Cancel">
                                                                            <button class="btn btn-info" id="btn_add"
                                                                                name="btn_add">Add</button>
                                                                        </div>

                                                                    </form>
                                                                </div>
                                                            </div>

                                                        </div>
                                                        <script type="text/javascript">
                                                            $(function () {
                                                                $("#students").dataTable(
                                                                    { "aaSorting": [[0, "asc"]] }
                                                                );
                                                            });
                                                        </script>
                                                    </div>




                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Page body end -->
                            </div>

                        </div>

                        <!-- Main-body end -->
                        <div id="styleSelector">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>


    <script>
 const programSelect = document.getElementById("prog");
const subjectSelect = document.getElementById("option-requisite");
const inputRequisite = document.getElementById("input-requisite");

programSelect.addEventListener("change", function () {
    let programId = this.value;
    subjectSelect.innerHTML = '<option value="">- Select Subject -</option>';
    subjectSelect.disabled = true;

    if (programId) {
        fetch("programs_subjects.php?program_id=" + programId)
            .then(res => res.json())
            .then(data => {
                if (data.length > 0) {
                    data.forEach(sub => {
                        let opt = document.createElement("option");
                        opt.value = sub.SUBJECT_CODE;
                        opt.textContent = sub.SUBJECT_CODE+" - "+sub.DESCRIPTION;
                        subjectSelect.appendChild(opt);
                    });
                }
                // Always add the “Specify” option
                let specifyOption = document.createElement("option");
                specifyOption.value = "Specify";
                specifyOption.textContent = "Others pls. specify...";
                subjectSelect.appendChild(specifyOption);

                subjectSelect.disabled = false;
            })
            .catch(err => console.error("Fetch error:", err));
    }
});
    function validateForm() {
      const sub = document.getElementById("sub");
      const input_requisite = document.getElementById("input-requisite");
      const opt_requisite = document.getElementById("option-requisite");
      
    if (sub.value === input_requisite.value || opt_requisite.value.trim() === sub.value) {
        alert("Pre/Co-requisite can not be the same to the subject code.");
        input_requisite.focus();
        return false;
    }
    return true;
}
function handleSelectChange() {
    if (subjectSelect.value === "Specify") {
        inputRequisite.style.display = "block";
        inputRequisite.required = true;
        inputRequisite.value = "";
        inputRequisite.focus();
    } else {
        inputRequisite.style.display = "none";
        inputRequisite.required = false;
        inputRequisite.value = subjectSelect.value; // 👈 This line ensures the selected value is posted
    }
}

        var slideIndex = 0;
        showSlides();

        function showSlides() {
            var i;
            var slides = document.getElementsByClassName("mySlides");
            var dots = document.getElementsByClassName("dot");
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            slideIndex++;
            if (slideIndex > slides.length) { slideIndex = 1 }
            for (i = 0; i < dots.length; i++) {
                dots[i].className = dots[i].className.replace(" active", "");
            }
            slides[slideIndex - 1].style.display = "block";
            dots[slideIndex - 1].className += " active";
            setTimeout(showSlides, 5000); // Change image every 2 seconds
        }
    </script>
    <script src="assets/js/ie10-viewport-bug-workaround.js"></script>
    <?php include('includes/javascripts.php'); ?>
</body>

</html>