<!DOCTYPE html>
<html lang="en">

<head>
	<?php include 'includes/header.php'; ?>
	<!-- Favicon icon -->
	<?php include 'includes/stylesheets.php'; ?>
	<script type="text/javascript" src="assets/pages/notification/notification.js"></script>
</head>
<style>
	#heads th {
		background-color: #70ad47;
		font-weight: bold;
		padding: 0pt 5.03pt;
	}

	.heads_p {
		line-height: normal;
		text-align: center;

	}
	.grades-info{
	    font-weight: bold;
	    text-decoration: underline;
	}
</style>

<body>
	<?php include 'includes/loader.php'; ?>
	<div id="pcoded" class="pcoded">
		<div class="pcoded-overlay-box"></div>
		<div class="pcoded-container navbar-wrapper">

			<?php include 'includes/topnavbar.php'; ?>
			<div class="pcoded-main-container">
				<div class="pcoded-wrapper">
					<?php
                        include 'db.php';

                        $sql        = mysqli_query($conn, "SELECT * FROM user where USER_ID = '" . $_SESSION['ID'] . "'");
                        $row        = mysqli_fetch_assoc($sql);
                        $accesstype = $row['USER_TYPE'] ?? 'Staff';
                        if ($accesstype == 'ADMINISTRATOR') {
                            include 'includes/sidebar.php';
                        } else {
                            include 'includes/sidebar_faculty.php';
                        }
                    ?>

					<div class="pcoded-content">
						<!-- Page-header start -->
						<div class="page-header">
							<div class="page-block">
								<div class="row align-items-center">
									<div class="col-md-8">
										<div class="page-header-title">
											<h5 class="m-b-10">Student Records</h5>
											<p class="m-b-0">View Student Info. and student grades. </p>
										</div>
									</div>
									<div class="col-md-4">
										<ul class="breadcrumb">
											<li class="breadcrumb-item">
												<a href="index.html"> <i class="fa fa-home"></i> </a>
											</li>
											<li class="breadcrumb-item"><a href="#!">Users</a>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</div>
						<!-- Page-header end -->

						<div class="pcoded-inner-content">
							<!-- Main-body start -->
							<div class="main-body">
								<div class="page-wrapper">
									<!-- Page body start -->
									<div class="page-body">
										<div class="row">
										    <?php
                                                if (isset($_GET['id'])) {
                                                    $id = intval($_GET['id']);

                                                    include 'db.php';

                                                    $stmt = $conn->prepare("SELECT LRN_NO, LASTNAME, FIRSTNAME, MIDDLENAME from student_info WHERE STUDENT_ID= ?");
                                                    $stmt->bind_param("i", $id);
                                                    $stmt->execute();
                                                    $stmt->bind_result($lrn, $lname, $fname, $mname);
                                                    $stmt->fetch();
                                                    $stmt->close();

                                                    $lname = $lname ?: 'Unknown';
                                                    $fname = $fname ?: 'Unknown';
                                                    $mname = $mname ?: 'Unknown';
                                                    $lrn   = $lrn ?: 'Unknown';

                                                ?>

											<div class="col-md-12">
												<div class="card">
													<div class="card-header">
														<h5><?php echo $lname.', '.$fname.' '.$mname?></h5>

													</div>
													<div class="card-block">
														<div class="table-responsive">
															<div class="panel panel-default">
																<div class="panel-heading">
																</div>



																<div class="panel-body">

																	<table class="table table-hover table-bordered">
																		<thead>
																			<tr id="heads">
																				<th rowspan="2"
																					style="width:15%; padding-left:10px;">
																					<p class="heads_p">
																						<span>TERM</span>
																					</p>
																				</th>

																				<th colspan="2" rowspan="2"
																					style="width:55%">
																					<p class="heads_p">
																						<span>COURSE &amp; DESCRIPTIVE
																							TITLE</span>
																					</p>
																				</th>
																				<th style="width:30%" colspan="2">
																					<p class="heads_p"
																						style="padding-top: 10px">
																						GRADES
																					</p>
																				</th>
																				<th rowspan="2"
																					style="width:15%; padding-left:10px;">
																					<p class="heads_p">
																						<span>CREDIT</span>
																					</p>
																				</th>
																			</tr>
																			<tr id="heads">
																				<th>
																					<p class="heads_p"
																						style="padding-top: 10px">FINAL
																					</p>
																				</th>
																				<th>
																					<p class="heads_p"
																						style="padding-top: 10px">
																						RE-EXAM</p>
																				</th>
																			</tr>
																		</thead>
																		<tbody>

																		<?php
function showgrades($lrn, $sem, $year)
{
    require_once 'gs_get_student_grades.php';
    include 'db.php';

    $totalgrades = 0;
    $totalunit   = 0;
    $gsIDs       = [];
    $sy          = "";

    // ðŸ”¹ Get Google Sheet IDs where the student is enrolled
    $stmt = "SELECT DISTINCT(GSID) AS SheetID, SEMESTER, SCHOOL_YEAR, YEAR_SECTION
             FROM section, classes, enrollment
             WHERE section.SECTION_ID = classes.SECTION_ID
               AND classes.CLASS_ID = enrollment.CLASS_ID
               AND enrollment.STUDENT_ID = '$lrn'
               AND section.YEAR_SECTION LIKE '$year%'
               AND section.SEMESTER = '$sem'
               ORDER BY section.SCHOOL_YEAR";

    $sql = mysqli_query($conn, $stmt);

    while ($row = mysqli_fetch_assoc($sql)) {
        $gsIDs[] = $row['SheetID'];
        $sy      = $row['SCHOOL_YEAR'];
    }

    $grades = getStudentGrades($lrn, $gsIDs);
    ?>

    <?php if (!empty($grades['Subjects'])): ?>
        <?php
        $firstRow = true;
        foreach ($grades['Subjects'] as $subject => $gradesList):
        ?>
            <tr>
                <?php if ($firstRow): ?>
                    <td style="width:15%;" rowspan="<?php echo count($grades['Subjects']); ?>">
                        <p style="font-weight: bold">
                            <?php
                            $levels = [1 => "1st Yr", 2 => "2nd Yr", 3 => "3rd Yr", 4 => "4th Yr"];
                            $yearlevel = $levels[$year[0]] ?? "Unknown";
                            echo htmlspecialchars($yearlevel . ' - ' . $sem) . " Semester";
                            ?>
                        </p>
                        (<?php echo htmlspecialchars($sy); ?>)
                    </td>
                    <?php $firstRow = false; ?>
                <?php endif; ?>

                <td style="width:15%;">
                    <?php echo htmlspecialchars($subject); ?>
                </td>

                <td style="width:42.5%;">
                    <?php
                    // ðŸ”¹ Get subject description
                    $stmt = $conn->prepare("SELECT DESCRIPTION FROM subjects WHERE SUBJECT_CODE = ? AND YEAR_LEVEL LIKE '$year%'");
                    $stmt->bind_param("s", $subject);
                    $stmt->execute();
                    $stmt->bind_result($description);
                    $stmt->fetch();
                    $stmt->close();

                    $description = $description ?: 'Unknown';
                    echo htmlspecialchars($description);
                    ?>
                </td>

                <?php 
 if (!function_exists('ps_grade')) {
    function ps_grade($grade) {
        // Treat empty, 0, or "-" as INC
        if ($grade === "-" || $grade == 0) {
            return "INC";
        }
        if ($grade === "") {
            return "";
        }

        $grade = round(floatval($grade)); // Round to nearest integer

        // Apply the grading scale
        if ($grade >= 99) return number_format(1.00, 2);
        if ($grade == 98) return number_format(1.10, 2);
        if ($grade == 97) return number_format(1.20, 2);
        if ($grade == 96) return number_format(1.25, 2);
        if ($grade == 95) return number_format(1.30, 2);
        if ($grade == 94) return number_format(1.40, 2);
        if ($grade == 93) return number_format(1.50, 2);
        if ($grade == 92) return number_format(1.60, 2);
        if ($grade == 91) return number_format(1.70, 2);
        if ($grade == 90) return number_format(1.75, 2);
        if ($grade == 89) return number_format(1.80, 2);
        if ($grade == 88) return number_format(1.90, 2);
        if ($grade == 87) return number_format(2.00, 2);
        if ($grade == 86) return number_format(2.10, 2);
        if ($grade == 85) return number_format(2.20, 2);
        if ($grade == 84) return number_format(2.25, 2);
        if ($grade == 83) return number_format(2.30, 2);
        if ($grade == 82) return number_format(2.40, 2);
        if ($grade == 81) return number_format(2.50, 2);
        if ($grade == 80) return number_format(2.60, 2);
        if ($grade == 79) return number_format(2.70, 2);
        if ($grade == 78) return number_format(2.75, 2);
        if ($grade == 77) return number_format(2.80, 2);
        if ($grade == 76) return number_format(2.90, 2);
        if ($grade == 75) return number_format(3.00, 2);

        // Below 75 → 5.00
        if ($grade >=65 && $grade < 75) return number_format(5.00, 2);
        
        if($grade < 65) return "INC";
        // Fallback (shouldn't happen)
        return "INC";
    }
}
                
                ?>

                <td style="width:15%; text-align:center">
                    <?= ps_grade($gradesList[0] ?? ""); ?>
                </td>
                <td style="width:15%; text-align:center">
                    <?= ps_grade($gradesList[1] ?? ""); ?>
                </td>

                <td style="width:42.5%;">
                    <?php
                    // ðŸ”¹ Get credit units
                    $stmt = $conn->prepare("SELECT UNITS FROM subjects WHERE SUBJECT_CODE = ? AND YEAR_LEVEL LIKE '$year%'");
                    $stmt->bind_param("s", $subject);
                    $stmt->execute();
                    $stmt->bind_result($units);
                    $stmt->fetch();
                    $stmt->close();

                    $units = is_numeric($units) ? floatval($units) : 0;
                    echo htmlspecialchars($units);
                    ?>
                </td>
            </tr>

            <?php
            // Compute weighted total
            $totalunit += $units;
            $grade1 = isset($gradesList[1]) ? ($gradesList[1]) : 0;
            $grade0 = isset($gradesList[0]) ? ($gradesList[0]) : 0;
            
            // Use 2nd grade if it exists and not 0, otherwise use the 1st
            /*$finalGrade = ($grade1 != 0) ? $grade1 : $grade0;

            $totalgrades += ($finalGrade * $units);*/
            $finalGrade = ($grade1 != 0) ? $grade1 : $grade0;

            // convert grade to float — if not numeric, force 0
            $finalGrade = is_numeric($finalGrade) ? floatval($finalGrade) : 0;
            
            $totalgrades += ($finalGrade * $units);
            ?>
        <?php endforeach; ?>

        <tr>
            <td colspan="6" style="font-weight:bold; text-align: right">GWA = 
           
                <?php
                if($totalunit > 0 && $totalgrades > 0)
                 { 
                     $gwa= $totalgrades / $totalunit;
            
                    // Return with 2 decimal places formatted
                    echo number_format($gwa,2).' ('.ps_grade($gwa).')';
                
                 }
                else{ echo "N/A";
                }
                ?>
            </td>
        </tr>

    <?php else: ?>
        <!-- Optional message if no grades found -->
        <!--
        <tr>
            <td colspan="5" style="text-align:center; color:orange;">
                * No grades found for this semester or year level.
            </td>
        </tr>
        -->
    <?php endif;
}


                                                                                    showgrades($lrn, "First", "1");
                                                                                    showgrades($lrn, "Second", "1");

                                                                                    showgrades($lrn, "First", "2");
                                                                                    showgrades($lrn, "Second", "2");

                                                                                    showgrades($lrn, "First", "3");
                                                                                    showgrades($lrn, "Second", "3");

                                                                                    showgrades($lrn, "First", "4");
                                                                                    showgrades($lrn, "Second", "4");

                                                                                ?>
																		</tbody>
																	</table>
																</div>

															</div>
														</div>
													</div>
												</div>
											</div>
                                        <?php }?>
										</div>
									</div>
								</div>
								<!-- Page body end -->
							</div>

						</div>
						<div class="modal fade" id="edit_user" role="dialog">
							<div class="modal-dialog">

								<!-- Modal content-->
								<div class="modal-content">
									<div class="modal-header">
										<button type="button" class="close" data-dismiss="modal">&times;</button>
									</div>
									<div class="modal-body">
										<form class="form-group" method="POST" action="edit_user.php">
											<div class="container">
												<div id="e_user">

												</div>
											</div>
									</div>

									<div class="modal-footer">

										<button type="submit" class="btn btn-primary">Save</button>
										</form>
										<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	</div>
	</div>


	<script>
		var slideIndex = 0;
		showSlides();

		function showSlides() {
			var i;
			var slides = document.getElementsByClassName("mySlides");
			var dots = document.getElementsByClassName("dot");
			for (i = 0; i < slides.length; i++) {
				slides[i].style.display = "none";
			}
			slideIndex++;
			if (slideIndex > slides.length) { slideIndex = 1 }
			for (i = 0; i < dots.length; i++) {
				dots[i].className = dots[i].className.replace(" active", "");
			}
			slides[slideIndex - 1].style.display = "block";
			dots[slideIndex - 1].className += " active";
			setTimeout(showSlides, 5000); // Change image every 2 seconds
		}
	</script>
	<script src="assets/js/ie10-viewport-bug-workaround.js"></script>
	<?php include 'includes/javascripts.php'; ?>
</body>

</html>