<?php
include 'db.php';
header('Content-Type: application/json');

if (isset($_GET['program_id']) && isset($_GET['section_id'])) {
    $program_id = intval($_GET['program_id']);
    $section_id = intval($_GET['section_id']);

    // Get YEAR_SECTION from section table
    $secQuery = mysqli_query($conn, "SELECT YEAR_SECTION FROM section WHERE SECTION_ID = $section_id LIMIT 1");
    $secRow = mysqli_fetch_assoc($secQuery);
    $year_section = isset($secRow['YEAR_SECTION']) ? mysqli_real_escape_string($conn, trim($secRow['YEAR_SECTION'])) : '';
    $year=$year_section[0];

    if ($year_section != '') {
        // Fetch only the necessary columns and DISTINCT SUBJECT_ID
        $sql = "
            SELECT DISTINCT subjects.SUBJECT_ID, subjects.SUBJECT_CODE, subjects.DESCRIPTION from subjects, section, program
            WHERE
                subjects.PROGRAM_ID=section.PROGRAM_ID
            AND
                section.PROGRAM_ID=program.PROGRAM_ID
            AND
                program.PROGRAM_ID = $program_id
            AND 
                subjects.YEAR_LEVEL LIKE '$year%'
            ORDER BY subjects.SUBJECT_CODE ASC;
        ";

        $res = mysqli_query($conn, $sql);
        $subjects = [];
        while ($row = mysqli_fetch_assoc($res)) {
            $subjects[] = $row;
        }

        echo json_encode($subjects);
        exit;
    }
}

// Fallback: empty array if parameters missing or no subjects found
echo json_encode([]);
exit;
?>
