<div id="dataModal" class="modal">
  <div class="modal-content">
    <span class="close" id="closeModal">&times;</span>

    <?php require_once 'gs_display_deans_list.php'; 
          require_once 'calc_grades.php';?>
    <?php include 'db.php'; //htmlspecialchars($sheetName)?>

    <h3><?= 'Rank List (SY: '.$sy.' - '.$ys.') - '.$sem.' Semester' ?></h3>

    <form method="post">
    <?php
    // -----------------------------
    // DISPLAY TABLE
    // -----------------------------
    if (empty($values)) {
        echo "<p>No data found.</p>";
        return;
    }

    $headers = $values[0];

    // Find "ID#" column
    $idIndex = null;
    foreach ($headers as $idx => $h) {
        if (trim(strtolower($h)) === 'id#' || trim(strtolower($h)) === 'id') {
            $idIndex = $idx;
            break;
        }
    }

    // Find "GWA" column
    $gwaIndex = null;
    foreach ($headers as $idx => $h) {
        if (trim(strtolower($h)) === 'gwa') {
            $gwaIndex = $idx;
            break;
        }
    }

    if ($idIndex === null || $gwaIndex === null) {
        echo "<p><strong>Could not find 'ID#' or 'GWA' column in the sheet.</strong></p>";
        return;
    }

    // Collect unique IDs from the sheet
    $lrnNumbers = [];
    for ($r = 1; $r < count($values); $r++) {
        $lrn = trim($values[$r][$idIndex] ?? '');
        if ($lrn !== '') {
            $lrnNumbers[$lrn] = $lrn;
        }
    }
    $lrnNumbers = array_values($lrnNumbers);

    // Query database for student names
    $namesMap = [];
    if (!empty($lrnNumbers)) {
        $placeholders = implode(',', array_fill(0, count($lrnNumbers), '?'));
        $sql = "SELECT LRN_NO, CONCAT(LASTNAME, ', ', FIRSTNAME, ' ', IFNULL(MIDDLENAME, '')) AS fullname 
                FROM student_info 
                WHERE LRN_NO IN ($placeholders)";
        
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $types = str_repeat('s', count($lrnNumbers));
            $bind = [];
            $bind[] = &$types;
            foreach ($lrnNumbers as $i => $v) {
                $bind[] = &$lrnNumbers[$i];
            }
            call_user_func_array([$stmt, 'bind_param'], $bind);

            $stmt->execute();
            $res = $stmt->get_result();
            while ($row = $res->fetch_assoc()) {
                $namesMap[$row['LRN_NO']] = $row['fullname'];
            }
            $stmt->close();
        }
    }

// Display table (first 3 columns + Name)
echo '<table border="1" cellspacing="0" cellpadding="5">';
echo '<thead><tr>';

// Display first 3 headers
for ($i = 0; $i < min(3, count($headers)); $i++) {
    echo '<th>' . htmlspecialchars($headers[$i]) . '</th>';
}

// Add Name column
echo '<th>Name</th>';
echo '</tr></thead>';

echo '<tbody>';
for ($r = 1; $r < count($values); $r++) {
    echo '<tr>';
    
    // Display only first 3 columns
    for ($c = 0; $c < min(3, count($headers)); $c++) {

        $cell = trim($values[$r][$c] ?? '');

        // 👉 FORMAT COLUMN 3 (index 2)
        if ($c == 2 && $cell !== "") {
            // Example: turn "2" into "2.00"
            $cell = calc_grade($cell);
        }

        echo '<td>' . htmlspecialchars($cell) . '</td>';
    }

    // Add Name column
    $lrn = trim($values[$r][$idIndex] ?? '');
    $name = $namesMap[$lrn] ?? 'Not Found';
    echo '<td>' . htmlspecialchars($name) . '</td>';

    echo '</tr>';
}
echo '</tbody>';
echo '</table>';


    // -----------------------------
    // SAVE TO DATABASE
    // -----------------------------
    if (isset($_POST['saveToDb'])) {
        $insert = $conn->prepare("
            INSERT INTO deans_list (LRN_NO, SECTION_ID, GWA)
            VALUES (?, ?, ?)
            ON DUPLICATE KEY UPDATE GWA = VALUES(GWA)
        ");

        if (!$insert) {
            echo "<p style='color:red;'>Database error: " . $conn->error . "</p>";
        } else {
            
            // Remove all previous records                
            $del = $conn->prepare("DELETE from deans_list WHERE SECTION_ID=?");
            $del->bind_param("s", $sec_id);
            $del->execute();
            
            $count = 0;
            for ($r = 1; $r < count($values)+1; $r++) {
                $lrn = trim($values[$r][$idIndex] ?? '');
                $gwa = trim($values[$r][$gwaIndex] ?? '');
                if ($lrn !== '' && is_numeric($gwa)) {
                    $insert->bind_param("sds", $lrn, $sec_id, $gwa);
                    $insert->execute();
                    $count++;
                }
            }
            $alert = 
            "<script>
            showAlert('success', 'Submitted', 'List Submitted Successfully. {$count} records added to the database!');
            </script>";
        }
    }
    ?>

    <br>
    <button type="submit" name="saveToDb" class="btn btn-info">Promote to Overall Ranking</button>
    </form>
  </div>
</div>
