<?php
require_once __DIR__ . '/vendor/autoload.php';

session_start();

$client = new Google_Client();
$client->setAuthConfig('client_secret_1045766898749-1ph0oeqnvldo2j7srgaebm7i0p33it1a.apps.googleusercontent.com.json');
$client->setRedirectUri('https://sscprojects.site/ccs/oauth2callback.php');
$client->addScope(Google_Service_Sheets::SPREADSHEETS);
$client->addScope(Google_Service_Drive::DRIVE);
$client->setAccessType('offline');   // ✅ Needed for refresh token
$client->setPrompt('consent');       // ✅ Forces Google to return refresh token

if (isset($_GET['code'])) {
    $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);

    if (isset($token['error'])) {
        die('Error fetching token: ' . htmlspecialchars($token['error_description']));
    }

    // Merge old + new token (important so refresh_token is not lost)
    $savedToken = [];
    if (file_exists('token.json')) {
        $savedToken = json_decode(file_get_contents('token.json'), true);
    }
    $mergedToken = array_merge($savedToken, $token);

    // Save to file
    file_put_contents('token.json', json_encode($mergedToken));

    // Store in session too
    $_SESSION['access_token'] = $mergedToken;

    header('Location: index.php'); 
    exit;
} else {
    echo "No code parameter found.";
}
