<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submitb'])) {
    include 'db.php';

    // ====== Fetch and sanitize input ======
    $studentid = trim($_POST['idBox'] ?? '');
    $classid   = trim($_POST['classid'] ?? '');
    $type      = trim($_POST['studenttype'] ?? '');
    $user      = $_SESSION['ID'] ?? 0;

    // ====== Check if student exists ======
    $check_stmt = $conn->prepare("SELECT 1 FROM student_info WHERE LRN_NO = ?");
    $check_stmt->bind_param("s", $studentid);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows > 0) {

        // ====== Check if already enrolled ======
        $check_stmt1 = $conn->prepare("SELECT 1 FROM enrollment WHERE STUDENT_ID = ? AND CLASS_ID = ?");
        $check_stmt1->bind_param("ss", $studentid, $classid);
        $check_stmt1->execute();
        $check_stmt1->store_result();

        if ($check_stmt1->num_rows === 0) {
            // ====== Insert into enrollment ======
            $stmt = $conn->prepare("
                INSERT INTO enrollment (STUDENT_ID, CLASS_ID, TYPE)
                VALUES (?, ?, ?)
            ");
            $stmt->bind_param("sss", $studentid, $classid, $type);

            if ($stmt->execute()) {
                // ====== Log the transaction ======
                $log_msg = "Added student $studentid to class $classid";
                $log_stmt = $conn->prepare("
                    INSERT INTO history_log (transaction, user_id, date_added)
                    VALUES (?, ?, NOW())
                ");
                $log_stmt->bind_param("si", $log_msg, $user);
                $log_stmt->execute();
                $log_stmt->close();

                // Success alert
                $alert = "
                <script>
                    showAlert('success', 'Succeed!', 'Successfully added.');
                    setTimeout(() => {
                        if (document.referrer) {
                            window.location.href = document.referrer;
                        } else {
                            window.location.href = 'main.php?page=section';
                        }
                    }, 2000);
                </script>";
            } else {
                // Failed to insert
                $alert = "
                <script>
                    showAlert('error', 'Error!', 'Failed to add student to class.');
                    setTimeout(() => {
                        if (document.referrer) {
                            window.location.href = document.referrer;
                        } else {
                            window.location.href = 'main.php?page=section';
                        }
                    }, 3000);
                </script>";
            }

            $stmt->close();
        } else {
            // Already enrolled
            $alert = "
            <script>
                showAlert('warning', 'Notice', 'Student is already enrolled in this class.');
                setTimeout(() => {
                    if (document.referrer) {
                        window.location.href = document.referrer;
                    } else {
                        window.location.href = 'main.php?page=section';
                    }
                }, 3000);
            </script>";
        }

        $check_stmt1->close();
    } else {
        // Student not found
        $alert = "
        <script>
            showAlert('warning', 'Notice', 'Student ID not found.');
            setTimeout(() => {
                if (document.referrer) {
                    window.location.href = document.referrer;
                } else {
                    window.location.href = 'main.php?page=section';
                }
            }, 3000);
        </script>";
    }

    $check_stmt->close();
    $conn->close();


}
?>
