<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submitb'])) {
    include 'db.php';

    // Fetch and sanitize input
    $lrn    = trim(strtoupper($_POST['lrn']));
    $ln     = trim(strtoupper($_POST['lname']));
    $fn     = trim(strtoupper($_POST['fname']));
    $mn     = trim(strtoupper($_POST['mname']));
    $gender = trim(strtoupper($_POST['gender']));
    $bp     = trim(strtoupper($_POST['bp']));
    $dob    = trim($_POST['dob']);
    $pob    = trim(strtoupper($_POST['pob']));
    $pg     = trim(strtoupper($_POST['pg']));
    $pga    = trim(strtoupper($_POST['pg_add']));
    $icc    = trim(strtoupper($_POST['icc']));
    $sy     = trim($_POST['sy']);
    $tny    = trim($_POST['tny']);
    $ave    = trim($_POST['ave']);
    $prog   = trim($_POST['prog']);
    $user   = $_SESSION['ID'];

    // Check if LRN already exists
    $check_stmt = $conn->prepare("SELECT 1 FROM student_info WHERE LRN_NO = ?");
    $check_stmt->bind_param("s", $lrn);
    $check_stmt->execute();
    $check_stmt->store_result();

    if ($check_stmt->num_rows >= 1) {
        $alert = 
        "<script>
        showAlert('warning', 'Notice', 'Student ID no. is not available. Already Exists');
        setTimeout(() => window.location.href = 'student_list.php', 4000);
        </script>";
    } else {
        // Prepare insert statement
        $stmt = $conn->prepare("INSERT INTO student_info 
            (LRN_NO, LASTNAME, FIRSTNAME, MIDDLENAME, BIRTH_PLACE, PARENT_GUARDIAN, P_ADDRESS, INT_COURSE_COMP, SCHOOL_YEAR, GEN_AVE, TOTAL_NO_OF_YEARS, DATE_OF_BIRTH, ADDRESS, GENDER, PROGRAM)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        $stmt->bind_param("sssssssssssssss", 
            $lrn, $ln, $fn, $mn, $bp, $pg, $pga, $icc, $sy, $ave, $tny, $dob, $pob, $gender, $prog
        );

        if ($stmt->execute()) {
            // Log the transaction
            $log_msg = "added $fn $ln as new student";
            $log_stmt = $conn->prepare("INSERT INTO history_log (transaction, user_id, date_added) VALUES (?, ?, NOW())");
            $log_stmt->bind_param("si", $log_msg, $user);
            $log_stmt->execute();

        $alert = 
        "<script>
        showAlert('success', 'Saved!', 'Successfully Added');
        setTimeout(() => window.location.href = 'student_list.php', 2000);
        </script>";
        } else {
            $alert = "
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    showAlert('error', 'Error!', 'Failed to Add new student');
                    setTimeout(() => window.location.href = 'student_list.php', 3000);
                });
            </script>";
			
        }

        $stmt->close();
    }

    $check_stmt->close();
    $conn->close();
}
?>
