<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $errors = [];

    // Required fields check
    $requiredFields = [
        'sy'       => '* School Year is required.',
        'ys'       => '* Year and section is required.',
        'prog'     => '* Program is required.',
        'semester' => '* Semester is required.',
        'status'   => '* Status is required.'
    ];

    foreach ($requiredFields as $field => $message) {
        if (empty(trim($_POST[$field] ?? ''))) {
            $errors[$field] = $message;
        }
    }

    if (empty($errors)) {

        $user     = $_SESSION['ID'] ?? 0;
        $sy       = trim($_POST['sy']);
        $ys       = trim($_POST['ys']);
        $prog     = trim($_POST['prog']);
        $semester = trim($_POST['semester']);
        $status   = trim($_POST['status']);
        $id       = trim($_POST['id'] ?? '');
        // Get program name
        $stmt = $conn->prepare("SELECT PROGRAM FROM program WHERE PROGRAM_ID = ?");
        $stmt->bind_param("s", $prog);
        $stmt->execute();
        $stmt->bind_result($program_name);
        $stmt->fetch();
        $stmt->close();

        $program_name = $program_name ?: 'Unknown';
        $filename = strtoupper($program_name . '_' . $ys . '_' . $sy . '_' . $semester.'SEM');
        $quiz_name="QUIZ_".$filename;
        // Insert new section
        if (empty($id)) {

            $section_existence = $conn->prepare("SELECT SECTION_ID FROM section WHERE PROGRAM_ID=? and YEAR_SECTION=? and SCHOOL_YEAR=? and SEMESTER=?");
            $section_existence->bind_param("ssss", $prog, $ys, $sy, $semester);
            $section_existence->execute();
            $section_existence->store_result();
            
                if ($section_existence->num_rows == 0) {
                    
                    require_once 'gs_copy_rename_file.php';
                    try {
                        $gsid = copyGoogleSheet($filename, "1ck4l904Jzuc-ZmqblzmDXGED7Jw9xoNzTjq8KJ4-hIE");
                        //$quiz_gsid=copyGoogleSheet("QUIZ_".$filename, "1dKLKZJh9Cq_iYVZJ8PnxhFwITwsi3uUUhUFdyInUxNA");
                        
                         require_once 'gs_sheet_permission_change.php';
                         
                         $change_access=makeFileEditable($gsid);
                         //$quiz_change_access=makeFileEditable($quiz_gsid);
                         
                        if (!$gsid && $change_access) {
                            throw new Exception("Google returned no file ID.");
                        }
                        /*if (!$quiz_gsid && $quiz_change_access) {
                            throw new Exception("Google returned no file ID for Quizzes table.");
                        }*/
                    } catch (Exception $e) {
                        die("Google API Error: " . $e->getMessage());
                    }
        
                    // Insert into section
                    $stmt = $conn->prepare("INSERT INTO section (SCHOOL_YEAR, YEAR_SECTION, GSID, PROGRAM_ID, SEMESTER, STATUS) 
                                            VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt->bind_param("ssssss", $sy, $ys, $gsid, $prog, $semester, $status);
                    
                    // Insert into history log
                    $stmt2 = $conn->prepare("INSERT INTO history_log (transaction, user_id, date_added) 
                                             VALUES (?, ?, NOW())");
                    $action = "added $filename in section";
                    $stmt2->bind_param("si", $action, $user);
        
                    if ($stmt->execute() && $stmt2->execute()) {
                    /*    
                    $getsectioninfo = $conn->prepare("SELECT SECTION_ID FROM section WHERE SCHOOL_YEAR=? and YEAR_SECTION=? and GSID=? and PROGRAM_ID=? and SEMESTER=? and STATUS=?");
                    $getsectioninfo->bind_param("ssssss", $sy, $ys, $gsid, $prog, $semester, $status);
                    $getsectioninfo->execute();
                    $getsectioninfo->bind_result($section_id);
                    $getsectioninfo->fetch();
                    $getsectioninfo->close();
                    $section_id = $section_id ?: 'Unknown';
                    
                     $quiz_stmt = $conn->prepare("INSERT INTO quizzes (SECTION_ID, QUIZ_GSID, NAME) VALUES (?, ?, ?)");
                     $quiz_stmt->bind_param("sss", $section_id, $quiz_gsid, $quiz_name);
                     $quiz_stmt->execute();
                     */
                        $alert = 
                        "<script>
                        showAlert('success', 'Succeed', 'Section created successfully');
                        setTimeout(() => window.location.href = 'main.php?page=section&id=$prog', 4000);
                        </script>";
                    } else {
                        $alert = 
                        "<script>
                        showAlert('error', 'Error', 'Failed to create');
                        setTimeout(() => window.location.href = 'main.php?page=section&id=$prog', 4000);
                        </script>"; 
                    }
        
                    $stmt->close();
                    $stmt2->close();
                } else {
                        $alert = 
                        "<script>
                        showAlert('warning', 'Notice', 'Section already exists.');
                        setTimeout(() => window.location.href = 'main.php?page=section&id=$prog', 4000);
                        </script>"; 
                }
            
            
        }
        // Update existing section
        else {
            require_once 'gs_rename_file.php';
            try {
                        // Get program name
                $stmt = $conn->prepare("SELECT GSID FROM section WHERE SECTION_ID = ?");
                $stmt->bind_param("s", $id);
                $stmt->execute();
                $stmt->bind_result($oldGSID);
                $stmt->fetch();
                $stmt->close();
                $fileId=$oldGSID?: 'Unknown';
                $gsid = renameGoogleSheet($fileId, $filename);
                if (!$gsid) {
                    throw new Exception("Google returned no file ID.");
                }
                
                        // Get quiz
                /*        
                $stmt = $conn->prepare("SELECT QUIZ_GSID FROM quizzes WHERE SECTION_ID = ?");
                $stmt->bind_param("s", $id);
                $stmt->execute();
                $stmt->bind_result($old_quiz_GSID);
                $stmt->fetch();
                $stmt->close();
                $quiz_fileId=$old_quiz_GSID?: 'Unknown';
                $quiz_gsid = renameGoogleSheet($quiz_fileId, $quiz_name);
                if (!$quiz_gsid) {
                    throw new Exception("Google returned no file ID.");
                }*/
            } catch (Exception $e) {
                die("Google API Error: " . $e->getMessage());
            }
            $stmt = $conn->prepare("UPDATE section 
                                    SET SCHOOL_YEAR = ?, YEAR_SECTION = ?, PROGRAM_ID = ?, SEMESTER = ?, STATUS = ? 
                                    WHERE SECTION_ID = ?");
            $stmt->bind_param("sssssi", $sy, $ys, $prog, $semester, $status, $id);
            
            

            if ($stmt->execute()) {
                $filename = $ys . '_' . $sy . '_' . $semester; // for logging
                $stmt2 = $conn->prepare("INSERT INTO history_log (transaction, user_id, date_added) 
                                         VALUES (?, ?, NOW())");
                $action = "updated $filename in section";
                $stmt2->bind_param("si", $action, $user);
                $stmt2->execute();
                $stmt2->close();
                        $alert = 
                        "<script>
                        showAlert('success', 'Updated', 'Successfully Updated.');
                        setTimeout(() => window.location.href = 'main.php?page=section&id=$prog', 4000);
                        </script>";
            } else {
                
                        $alert = 
                        "<script>
                        showAlert('error', 'Error', 'Failed to Update');
                        setTimeout(() => window.location.href = 'main.php?page=section&id=$prog', 4000);
                        </script>"; 
            }

            $stmt->close();
        }
    } else {
        // Handle validation errors
        foreach ($errors as $err) {
            echo "<div class='erlert'>$err</div>";
        }
        echo "<script>
                setTimeout(function(){ document.querySelectorAll('.erlert').forEach(el => el.style.display='none'); }, 3000);
              </script>";
    }
}

$conn->close();
