<?php
session_start();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    include('db.php');

    // Sanitize input
    $user = trim($_POST['user']);
    $pwd = $_POST['pwd'];

$ip = $_SERVER['REMOTE_ADDR'];
//$ua = $_SERVER['HTTP_USER_AGENT'];

    // Validate input
    if (empty($user) || empty($pwd)) {
        $msg= 'Username and password are required.';
        exit;
    }

    // Hash password (Note: MD5 is insecure, see note below)
    $hashed_pwd = md5($pwd);

    // Prepare the SQL statement
    $stmt = $conn->prepare("SELECT * FROM user WHERE USER = ? AND PASSWORD = ? AND STATUS = 'Active'");
    $stmt->bind_param("ss", $user, $hashed_pwd);
    $stmt->execute();
    $result = $stmt->get_result();

    // Check if user exists
    if ($result && $result->num_rows > 0) {
        $use = $result->fetch_assoc();
        session_regenerate_id(true); // Prevent session fixation

        // Set session variables
        $_SESSION['ID'] = $use['USER_ID'];
        $_SESSION['fname'] = $use['FIRSTNAME'];
        $_SESSION['pic'] = $use['PHOTO'];
        $_SESSION['accesstype'] = $use['USER_TYPE'];
        $id = $use['USER_ID'];

        // Log the login
        $log_stmt = $conn->prepare("INSERT INTO history_log (transaction, user_id, date_added, details) VALUES (?, ?, NOW(),?)");
        $action = 'logged in';
        $log_stmt->bind_param("sis", $action, $id, $ip);
        $log_stmt->execute();
            // If gs_login.php must run, wrap it in try/catch
            if (file_exists('gs_login.php')) {
                require 'gs_login.php';
                header("Location: index.php");
                exit();
            }
            else{ header("Location: login.php");}

    } else {
        $msg= '<strong style="color:#E8996A">Login failed. Please check your credentials or wait until your account is approved.</strong>';
        $alert = 
        "<script>
        showAlert('warning', 'Failed to Login', 'Incorrect username or password, or your account is still pending approval.');
        </script>";
    }

    $stmt->close();
    $conn->close();
}
?>
