<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('includes/header.php'); ?>
    <!-- Favicon icon -->
    <?php include('includes/stylesheets.php'); ?>
<style>
/* Hidden by default */
.card {
  opacity: 0;
  transform: translateY(40px);
  transition: 
    opacity 1.2s ease-in-out,
    transform 1.2s ease-in-out;
  will-change: opacity, transform;
}

/* When visible */
.card.visible {
  opacity: 1;
  transform: translateY(0);
}

/* Smooth stagger effect */
.card[data-index] {
  transition-delay: calc(var(--i) * 0.2s);
}
/* pop up video */
/* Modal Container */
.modal {
  display: none; /* Hidden by default */
  position: fixed;
  z-index: 999999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.6);
}

/* Modal Content Box */
.modal-content {
  background-color: #fff;
  margin: 10% auto;
  padding: 20px;
  width: 80%;
  max-width: 600px;
  border-radius: 8px;
  position: relative;
}

/* Close Button */
.close-vid {
  color: #aaa;
  float: right;
  font-size: 28px;
  font-weight: bold;
  position: absolute;
  top: 10px;
  right: 20px;
  cursor: pointer;
}
/* end of popup video */
</style>
</head>

<body>
    <?php include('includes/loader.php'); ?>
    <div id="pcoded" class="pcoded">
        <div class="pcoded-overlay-box"></div>
        <div class="pcoded-container navbar-wrapper">

            <?php include('includes/topnavbar.php'); ?>
            <div class="pcoded-main-container">
                <div class="pcoded-wrapper">
                    
                        <!-- Video Tutorial Modal -->
                        <div id="tutorialModal" class="modal">
                          <div class="modal-content">
                            <span class="close-vid">&times;</span>
                            <h2>Welcome!</h2>
                            <p>Here's a quick tutorial to get you started:</p>
                            <video controls width="100%">
                              <source src="assets/videos/ccs-tutorial-main-20251018122904.mp4" type="video/mp4">
                              Your browser does not support the video tag.
                            </video>
                          </div>
                        </div>
                    <?php
                    include 'db.php';

                    $sql = mysqli_query($conn, "SELECT * FROM user where USER_ID = '" . $_SESSION['ID'] . "'");
                    $row = mysqli_fetch_assoc($sql);
                    $accesstype = $row['USER_TYPE'] ?? 'Staff';
                        if ($accesstype == 'ADMINISTRATOR') {
                            include 'includes/sidebar.php';
                        } else {
                            include 'includes/sidebar_faculty.php';
                        }
                        ?>
                    <div class="pcoded-content">
                        <!-- Page-header start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">Dashboard</h5>
                                            <p class="m-b-0" style="font-weight:600">Class Records with Grades
                                                Automation, Analytics, and Printable Reports
           <?php 
           include 'db.php';
           $stmt = $conn->prepare("SELECT SCHOOL_YEAR from school_year WHERE CURRENT = ?");
           $status='Yes';
            $stmt->bind_param("s", $status);
            $stmt->execute();
            $stmt->bind_result($sy);
            $stmt->fetch();
            $stmt->close();
            
            $sy = $sy ?: 'Unknown';
            echo ". Current SY: ".$sy;
?>    
                                                
                                                
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item">
                                                <a href="index.html"> <i class="fa fa-home"></i> </a>
                                            </li>
                                            <li class="breadcrumb-item"><a href="#!">Dashboard</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Page-header end -->
                        <div class="pcoded-inner-content">
                            <!-- Main-body start -->
                            <div class="main-body">
                                <div class="page-wrapper">
                                    <!-- Page-body start -->
                                    <div class="page-body">
                                        <div class="row">
                                            <!-- Material statustic card start -->
                                            
                                              <?php  // SQL query to count rows
                                                                     function count_students_by_school_year_per_program($program){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(distinct(STUDENT_ID)) as total FROM enrollment, classes, section, school_year, program 
                                                                    where enrollment.CLASS_ID=classes.CLASS_ID
                                                                    and classes.SECTION_ID=section.SECTION_ID
                                                                    and section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and school_year.CURRENT='Yes' 
                                                                    and section.PROGRAM_ID=program.PROGRAM_ID and program.PROGRAM='$program'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                                  
                                              <?php  // SQL query to count rows
                                                                     function count_students_by_school_year_all_programs(){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(distinct(STUDENT_ID)) as total FROM enrollment, classes, section, school_year, program 
                                                                    where enrollment.CLASS_ID=classes.CLASS_ID
                                                                    and classes.SECTION_ID=section.SECTION_ID
                                                                    and section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and school_year.CURRENT='Yes' 
                                                                    and section.PROGRAM_ID=program.PROGRAM_ID";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                              
                                              <?php  // SQL query to count rows
                                                                    function count_students_by_school_year(){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(distinct(STUDENT_ID)) as total FROM enrollment, classes, section, school_year, program 
                                                                    where enrollment.CLASS_ID=classes.CLASS_ID
                                                                    and classes.SECTION_ID=section.SECTION_ID
                                                                    and section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and school_year.CURRENT='Yes'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        return $row['total'];
                                                                    } else {
                                                                        return 0;
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                            <!-- 1st-->
                                            
                                             <div class="col-xl-4 col-md-12">
                                                <div class="card mat-stat-card">
                                                    <div class="card-block">
                                                        <div class="row align-items-center b-b-default">
                                                            <div class="col-sm-6 b-r-default p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-laptop text-c-purple f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                       <h5><?php count_students_by_school_year_per_program("BS IT"); ?></h5>
                                                                        <p class="text-muted m-b-0">BS IT<br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-globe text-c-green f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php count_students_by_school_year_per_program("BS IS"); ?></h5>
                                                                        <p class="text-muted m-b-0">BS IS<br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row align-items-center">
                                                            <div class="col-sm-6 p-b-20 p-t-20 b-r-default">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-slack text-c-red f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php count_students_by_school_year_per_program("BS CS"); ?></h5>
                                                                        <p class="text-muted m-b-0">BS CS<br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-server text-c-yellow f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5> <?php count_students_by_school_year_all_programs(); ?></h5>
                                                                        <p class="text-muted m-b-0">Total<br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                           
                                             <?php  // SQL query to count rows
                                             function count_sections($program){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM section, school_year, program where section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and section.PROGRAM_ID=program.PROGRAM_ID and program.PROGRAM='$program' and school_year.CURRENT='Yes' 
                                                                    and section.STATUS='Available'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                              <?php function count_all_sections(){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM section, school_year, program where section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and section.PROGRAM_ID=program.PROGRAM_ID and school_year.CURRENT='Yes' 
                                                                    and section.STATUS='Available'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                             <!-- 2nd-->
                                            <div class="col-xl-4 col-md-12">
                                                <div class="card mat-stat-card">
                                                    <div class="card-block">
                                                        <div class="row align-items-center b-b-default">
                                                            <div class="col-sm-6 b-r-default p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-hdd-o  text-c-blue f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                   <h5>
                                                                        <?php count_sections("BS IT");?>
                                                                   </h5>
                                                                        <p class="text-muted m-b-0">Section <br> in BS IT</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa  fa-id-badge text-c-green f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php count_sections("BS IS");?></h5>
                                                                       <p class="text-muted m-b-0">Section <br> in BS IS</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row align-items-center">
                                                            <div class="col-sm-6 p-b-20 p-t-20 b-r-default">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa  fa-wpforms text-c-red f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php count_sections("BS CS");?></h5>
                                                                        <p class="text-muted m-b-0">Section <br> in BS CS</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-microchip text-c-yellow f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php count_all_sections()?></h5>
                                                                        <p class="text-muted m-b-0">Total<br> Sections</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php  // SQL query to count rows
                                                                    function candidates($sem){
                                                                    include 'db.php';
                                                                    $sql = "select count(*) as total FROM deans_list, section, school_year WHERE deans_list.SECTION_ID=section.SECTION_ID
                                                                    and section.SCHOOL_YEAR=school_year.SCHOOL_YEAR
                                                                    and school_year.CURRENT='Yes'
                                                                    and section.SEMESTER='$sem'";
                                                                    $result = $conn->query($sql);
                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();   
                                                                    }
                                            ?>
                                                    <?php  // SQL query to count rows
                                                                     function student_status($stat){
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(distinct(STUDENT_ID)) as total FROM enrollment, classes, section, school_year 
                                                                    where enrollment.CLASS_ID=classes.CLASS_ID
                                                                    and classes.SECTION_ID=section.SECTION_ID
                                                                    and section.SCHOOL_YEAR=school_year.SCHOOL_YEAR 
                                                                    and school_year.CURRENT='Yes' 
                                                                    and section.STATUS='Available'
                                                                    and TYPE='$stat'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        return $row['total'];
                                                                    } else {
                                                                        return 0;
                                                                    }

                                                                    $conn->close();
                                             }
                                              ?>
                                             <!-- 3rd-->
                                            <div class="col-xl-4 col-md-12">
                                                <div class="card mat-stat-card">
                                                    <div class="card-block">
                                                        <div class="row align-items-center b-b-default">
                                                            
                                                            <div class="col-sm-6 b-r-default p-b-20 p-t-20">
                                                                <a href="deans_list_grouped.php">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-trophy text-c-purple f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5>                                                                    
                                                                    <?php
                                                                    candidates("First");
                                                                    ?></h5>
                                                                        <p class="text-muted m-b-0">Dean&apos;s Lister <br>1<sup>st</sup> Semester</p>
                                                                    </div>
                                                                </div>
                                                                </a>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <a href="deans_list_grouped.php">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-diamond text-c-yellow f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5>
                                                                    <?php
                                                                    candidates("Second");
                                                                    ?></h5>
                                                                       <p class="text-muted m-b-0">Dean&apos;s Lister <br>2<sup>nd</sup> Semester</p>
                                                                    </div>
                                                                </div>
                                                                </a>
                                                            </div>
                                                            
                                                        </div>
                                                        <div class="row align-items-center">
                                                            <div class="col-sm-6 p-b-20 p-t-20 b-r-default">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-user-circle-o text-c-green f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php 
                                                                        $regular=count_students_by_school_year()-student_status("Irregular");
                                                                        echo $regular;?></h5>
                                                                        <p class="text-muted m-b-0">Regular <br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-sm-6 p-b-20 p-t-20">
                                                                <div class="row align-items-center text-center">
                                                                    <div class="col-4 p-r-0">
                                                                        <i class="fa fa-user-secret text-c-red f-24"></i>
                                                                    </div>
                                                                    <div class="col-8 p-l-0">
                                                                        <h5><?php echo student_status("Irregular");?></h5>
                                                                        <p class="text-muted m-b-0">Irregular <br>Students</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="col-xl-4 col-md-12">
                                                <div class="card mat-clr-stat-card text-white fade-in-up"
                                                    style="background-color:#6FE423">
                                                    <div class="card-block">
                                                        <div class="row">
                                                            <div class="col-3 text-center"
                                                                style="background-color:#8AE94C">
                                                                <i class="fa fa-user mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5>
                                                                    <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM user where STATUS='Active' and USER_TYPE<>'ADMINISTRATOR'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?>
                                                                </h5>
                                                                <p class="m-b-0">Active</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <a href="subject_list.php">
                                                <div class="card mat-clr-stat-card text-white yellow ">
                                                    <div class="card-block">
                                                        <div class="row">
                                                            <div class="col-3 text-center bg-c-yellow">
                                                                <i class="fa fa-star mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5>
                                                                    <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM subjects";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?>
                                                                </h5>
                                                                <p class="m-b-0">Subjects</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </a>

                                            </div>
                                            <div class="col-xl-4 col-md-12">

                                                <div class="card mat-clr-stat-card text-white red">
                                                    <div class="card-block">
                                                        <div class="row">
                                                            <div class="col-3 text-center bg-c-red">
                                                                <i class="fa fa-eye-slash mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5>
                                                                    <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM user where STATUS='Pending'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?>
                                                                </h5>
                                                                <p class="m-b-0">Pending</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <a href="curriculum_list.php">
                                                <div class="card mat-clr-stat-card text-white"
                                                    style="background-color:#FF9B52">
                                                    <div class="card-block">
                                                        <div class="row">
                                                            <div class="col-3 text-center"
                                                                style="background-color:#FF7814">
                                                                <i class="fa fa-clone mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5>
                                                                    <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM program";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?>
                                                                </h5>
                                                                <p class="m-b-0">Programs</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </a>
                                            </div>
                                            <div class="col-xl-4 col-md-12">
                                                <a href="student_list.php">
                                                <div class="card mat-clr-stat-card text-white"
                                                    style="background-color:#D47FFF">
                                                    <div class="card-block">
                                                        <div class="row">
                                                            <div class="col-3 text-center"
                                                                style="background-color:#B014FF">
                                                                <i class="fa fa-graduation-cap mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5>    <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM student_info";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?></h5>
                                                                <p class="m-b-0">Students (All School Year)</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </a>
                                                
                                                <a href="faculty.php">
                                                <div class="card mat-clr-stat-card text-white blue">
                                                    <div class="card-block">
                                                    
                                                        <div class="row">
                                                            <div class="col-3 text-center bg-c-blue">
                                                                <i class="fa fa-group mat-icon f-24"></i>
                                                            </div>
                                                            <div class="col-9 cst-cont">
                                                                <h5> 
                                                                     <?php  // SQL query to count rows
                                                                    include 'db.php';
                                                                    $sql = "SELECT COUNT(*) as total FROM user where USER_TYPE='FACULTY' and STATUS <> 'Pending'";
                                                                    $result = $conn->query($sql);

                                                                    // Fetch and display the result
                                                                    if ($result) {
                                                                        $row = $result->fetch_assoc();
                                                                        echo $row['total'];
                                                                    } else {
                                                                        echo "Error.";
                                                                    }

                                                                    $conn->close();
                                                                    ?>
                                                                </h5>
                                                                <p class="m-b-0">Faculty</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                </a>
                                            </div>
                                            <!-- Material statustic card end -->
                                            <!-- order-visitor start -->


                                            <!-- order-visitor end -->
                                            <?php
                                           
                                            if (isset($_SESSION['accesstype']) && $_SESSION['accesstype']=='ADMINISTRATOR') { ?>
                                                <!--  sale analytics start -->
                                                <div class="col-xl-12 col-md-12">
                                                    <div class="card table-card">
                                                        <div class="card-header">
                                                            <h5>User's Activity Log</h5>
                                                            <div class="card-header-right">
                                                                <ul class="list-unstyled card-option">
                                                                    <li><i class="fa fa fa-wrench open-card-option"></i>
                                                                    </li>
                                                                    <li><i class="fa fa-window-maximize full-card"></i></li>
                                                                    <li><i class="fa fa-minus minimize-card"></i></li>
                                                                    <li><i class="fa fa-refresh reload-card"></i></li>
                                                                    <li><i class="fa fa-trash close-card"></i></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                        <div class="card-block">
                                                            <div class="table-responsive">
                                                                <table class="table table-hover m-b-0 without-header">
                                                                    <tbody>

                                                                        <?php
                                                                        include 'db.php';
                                                                        $sql = mysqli_query($conn, "SELECT history_log.transaction, history_log.user_id, history_log.details, history_log.date_added, user.USER_ID, user.LASTNAME, user.FIRSTNAME, user.PHOTO FROM history_log, user where history_log.user_id=user.USER_ID ORDER BY history_log.date_added DESC LIMIT 10");
                                                                        while ($row = mysqli_fetch_assoc($sql)) { ?>
                                                                            <tr>
                                                                                <td>
                                                                                    <div class="d-inline-block align-middle">
                                                                                        <img src="<?php echo $row['PHOTO']; ?>"
                                                                                            alt="user image"
                                                                                            class="img-radius img-40 align-top m-r-15">
                                                                                        <div class="d-inline-block">
                                                                                            <h6><?php echo $row['FIRSTNAME'] . " " . $row['LASTNAME']; ?>
                                                                                            </h6>
                                                                                            <p class="text-muted m-b-0">
                                                                                                <?php echo $row['transaction']; ?> <i><?php echo $row['details']; ?></i>
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>
                                                                                </td>
                                                                                <td class="text-right">
                                                                                    <h6 class="f-w-400">
                                                                                        <?php echo date("F j, Y, g:i a", strtotime($row['date_added'])); ?>&nbsp;
                                                                                        <i class="fa <?php
                                                                                        if ($row['transaction'] == "logged in") {
                                                                                            echo "fa-arrow-up text-c-green";
                                                                                        } else if ($row['transaction'] == "logged out") {
                                                                                            echo "fa-arrow-down text-c-red";
                                                                                        } else {
                                                                                            echo "fa-book text-c-yellow";
                                                                                        }
                                                                                        ?>
                                                                             m-r-15 ">
                                                                                        </i>
                                                                                    </h6>
                                                                                </td>
                                                                            </tr>


                                                                        <?php } ?>
                                                                    </tbody>
                                                                </table>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                            <!--  sale analytics end -->

                                           
                                        </div>
                                    </div>
                                </div>
                                <div id="styleSelector"> </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <script>
document.addEventListener("DOMContentLoaded", () => {
  const cards = document.querySelectorAll(".card");

  // Assign index for staggered delay
  cards.forEach((card, i) => {
    card.style.setProperty('--i', i);
  });

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      const card = entry.target;

      if (entry.isIntersecting) {
        // Fade in slowly
        card.classList.add("visible");
      } else {
        // Fade out smoothly when out of focus
        card.classList.remove("visible");
      }
    });
  }, {
    threshold: 0.2 // triggers when 20% of card is visible
  });

  // Observe all cards
  cards.forEach(card => observer.observe(card));
  
  // js for popup video
   const modal = document.getElementById("tutorialModal");
  const closeBtn = document.querySelector(".close-vid");

  // Check if the tutorial has already been shown
  if (!localStorage.getItem("tutorialShown")) {
    modal.style.display = "block";

    // Set flag in localStorage
    localStorage.setItem("tutorialShown", "true");
  }

  // Close the modal when user clicks the close button
  closeBtn.addEventListener("click", function () {
    modal.style.display = "none";
  });

  // Optional: close modal on click outside content
  window.addEventListener("click", function (event) {
    if (event.target === modal) {
      modal.style.display = "none";
    }
  });
  //end for pop up video
});
</script>
    <?php include('includes/javascripts.php'); ?>
</body>

</html>