<?php
require_once  'google_client_helper.php';

function getSheetLinkByName($spreadsheetId, $sheetName, $accesstype) {
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    // Get spreadsheet metadata
    $spreadsheet = $service->spreadsheets->get($spreadsheetId);
    $sheets = $spreadsheet->getSheets();

    foreach ($sheets as $sheet) {
        $properties = $sheet->getProperties();
        if ($properties->getTitle() === $sheetName) {
            $gid = $properties->getSheetId();
            // embed link
            return "https://docs.google.com/spreadsheets/d/{$spreadsheetId}/{$accesstype}#gid={$gid}";
        }
    }
    return null;
}

// Example usage:
/*
$spreadsheetId = "YOUR_SPREADSHEET_ID";
$link = getSheetLinkByName($spreadsheetId, "Grades");
if ($link) {
    echo "Direct link: " . $link;
} else {
    echo "Sheet tab not found.";
}*/
?>