<?php

function makeFileEditable($fileId) {
    try {
        $client = getGoogleClient();
        $driveService = new Google_Service_Drive($client);

        // Create "Anyone with the link can edit" permission
        $permission = new Google_Service_Drive_Permission([
            'type' => 'anyone',   // anyone with the link
            'role' => 'writer'    // writer = editor //reader = viewer
        ]);

        $driveService->permissions->create($fileId, $permission);

        // Return public editable link
        return true;
    } catch (Exception $e) {
        return "Error: " . $e->getMessage();
    }
}

// Example usage:
//$fileId = "YOUR_SPREADSHEET_ID";
//echo makeFileEditable($fileId); "https://docs.google.com/spreadsheets/d/$fileId/edit"