<?php
require __DIR__ . '/google_client_helper.php';

function renameGoogleSheet($fileId, $newName) {
    $client = getGoogleClient();
    $driveService = new Google_Service_Drive($client);

    $updateMetadata = new Google_Service_Drive_DriveFile([
        'name' => $newName
    ]);

    try {
        $updatedFile = $driveService->files->update($fileId, $updateMetadata, [
            'fields' => 'id, name'
        ]);
        return $updatedFile->id ?? null;
    } catch (Exception $e) {
        error_log("Google API rename error: " . $e->getMessage());
        return null;
    }
}
