<?php 
//require __DIR__ . '/google_client_helper.php';

function batchUpdateSheetValues($spreadsheetId, $updates) {
    $client = getGoogleClient();
    $sheetsService = new Google_Service_Sheets($client);

    $data = [];
    foreach ($updates as $range => $values) {
        $data[] = new Google_Service_Sheets_ValueRange([
            'range'  => $range,
            'values' => $values
        ]);
    }

    $body = new Google_Service_Sheets_BatchUpdateValuesRequest([
        'valueInputOption' => 'USER_ENTERED',
        'data' => $data
    ]);

    try {
        $result = $sheetsService->spreadsheets_values->batchUpdate(
            $spreadsheetId,
            $body
        );
        return "✅ Updated " . $result->getTotalUpdatedCells() . " cell(s).";
    } catch (Exception $e) {
        return "⚠️ Google API error: " . $e->getMessage();
    }
}

/* HOW TO USE THIS/ EXAMPLE BELOW
$spreadsheetId = "your-spreadsheet-id";

$updates = [
    "Sheet1!A1" => [["ID"]],
    "Sheet1!B1" => [["Name"]],
    "Sheet1!C1" => [["Score"]],
    "Sheet1!B5" => [["Manually changed"]],
];

echo batchUpdateSheetValues($spreadsheetId, $updates);
*/

?>