<?php
require_once __DIR__ . '/vendor/autoload.php';

$client = new Google_Client();
$client->setAuthConfig('client_secret_1045766898749-1ph0oeqnvldo2j7srgaebm7i0p33it1a.apps.googleusercontent.com.json');
$client->setRedirectUri('https://sscprojects.site/ccs/oauth2callback.php');
$client->addScope(Google_Service_Sheets::SPREADSHEETS);
$client->addScope(Google_Service_Drive::DRIVE);
$client->setAccessType('offline');
$client->setPrompt('consent'); // ✅ Ensures refresh_token is returned at least once

if (!file_exists('token.json')) {
    // No token yet → go to Google OAuth
    $authUrl = $client->createAuthUrl();
    header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));
    exit;
} else {
    $accessToken = json_decode(file_get_contents('token.json'), true);
    $client->setAccessToken($accessToken);

    if ($client->isAccessTokenExpired()) {
        if ($client->getRefreshToken()) {
            // ✅ Refresh automatically
            $newToken = $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            $accessToken = array_merge($accessToken, $newToken);
            file_put_contents('token.json', json_encode($accessToken));
        } else {
            // ❌ No refresh token → must re-authenticate
            unlink('token.json'); // delete old token
            $authUrl = $client->createAuthUrl();
            header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));
            exit;
        }
    }

    // Token is valid → go back to app
    header("Location: index.php");
    exit;
}
