<?php
require_once __DIR__ . '/google_client_helper.php';

/**
 * Get student data from a specific sheet tab
 */
function getStudentsTotalAverage($spreadsheetId, $sheetName) { 
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    // Wrap sheet name in quotes
    $range = "'{$sheetName}'!B1:AD1000";

    try {
        $response = $service->spreadsheets_values->get($spreadsheetId, $range);
        $values = $response->getValues();
    } catch (Google_Service_Exception $e) {
        // Sheet not found or invalid range
        return "Sheet not found"; // Return message
    }

    if (empty($values)) return [];

    $students = [];
    $headerSkipped = false;

    foreach ($values as $row) {
        $row = array_pad($row, 29, '');
        $id = trim($row[0]);
        $name = trim($row[1]);
        $average = trim($row[28]);

        if (!$headerSkipped) {
            if (strtolower($name) === 'full name' || strtolower($id) === 'id#') {
                $headerSkipped = true;
                continue;
            }
        }

        if ($id === '' || $name === '') continue;

        $students[] = [
            'id' => $id,
            'name' => $name,
            'average' => $average
        ];
    }

    return $students;
}

