<?php
require_once __DIR__ . '/google_client_helper.php';

function getStudentGrades($studentId, $spreadsheetIds) {
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    $allGrades = ["ID" => $studentId, "Name" => "", "Subjects" => []];

    // 👇 Add sheet names to exclude
    $excludedSheets = ["DO NOT DELETE", "Dean's List"]; 

    foreach ($spreadsheetIds as $spreadsheetId) {
        $spreadsheet = $service->spreadsheets->get($spreadsheetId);
        $sheets = $spreadsheet->getSheets();

        foreach ($sheets as $sheet) {
            $sheetName = $sheet->getProperties()->getTitle();

            // 🚫 Skip excluded sheets
            if (in_array($sheetName, $excludedSheets)) {
                continue;
            }

            $range = $sheetName . "!A:AD";

            $response = $service->spreadsheets_values->get($spreadsheetId, $range);
            $values = $response->getValues();

            if (empty($values)) continue;

            foreach ($values as $row) {
                if (isset($row[1]) && $row[1] == $studentId) {
                    $name = $row[2] ?? '';
                    $grade = $row[29] ?? ''; // adjust if needed

                    $allGrades['Name'] = $name;

                    if (!isset($allGrades['Subjects'][$sheetName])) {
                        $allGrades['Subjects'][$sheetName] = [];
                    }

                    $allGrades['Subjects'][$sheetName][] = $grade;
                }
            }
        }
    }

    return $allGrades;
}

/*
// Example usage
$spreadsheetIds = [
    "1cgkat6zcKM25nsRVlSQ3Ma2MLAmovxZJopK47NRI3tk",
    "1HsOVcIwu1NEMJT-x97cPSfqsOBum_zK0UYUZd-nCI9U",
    "170ew-ago7jQ2mg17LgwWVhksbs9-CyhLMJsd4VVc-uE"
];

$studentId = "12B0921";
$grades = getStudentGrades($studentId, $spreadsheetIds);
*/
?>
<!--<!DOCTYPE html>
<html>
<head>
    <title>Student Grades</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        table { border-collapse: collapse; width: 70%; margin: 0 auto; }
        th, td { border: 1px solid #ccc; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
        caption { font-size: 18px; margin-bottom: 10px; font-weight: bold; }
    </style>
</head>
<body>

<?php // if (!empty($grades['Subjects'])): ?>
    <table>
        <caption>Grades for <?php //echo htmlspecialchars($grades['Name']); ?> (<?php // echo htmlspecialchars($grades['ID']); ?>)</caption>
        <tr>
            <th>Subject</th>
            <th>Grade</th>
            <th>Re-Exam</th>
        </tr>
        <?php // foreach ($grades['Subjects'] as $subject => $gradesList): ?>
        <tr>
            <td><?php // echo htmlspecialchars($subject); ?></td>
            <td><?php // echo htmlspecialchars($gradesList[0] ?? ''); ?></td>
            <td><?php // echo htmlspecialchars($gradesList[1] ?? ''); ?></td>
        </tr>
        <?php // endforeach; ?>
    </table>
<?php // else: ?>
    <p style="text-align:center; color:red;">No grades found for Student ID: <?php //echo htmlspecialchars($studentId); ?></p>
<?php // endif; ?>

</body>
</html>-->