<?php
//require __DIR__ . '/vendor/autoload.php';
//require_once 'google_client_helper.php';

/**
 * ✅ Function to get Google Sheet values
 * @param string $spreadsheetId  Google Sheet ID
 * @param string $sheetName      Specific sheet/tab name
 * @param string $range          Range (default = A1:E)
 * @return array                 Returns 2D array of values
 */
function getGoogleSheetData($spreadsheetId, $sheetName, $range = 'A1:E') {
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    try {
        $response = $service->spreadsheets_values->get($spreadsheetId, $sheetName . '!' . $range);
        return $response->getValues() ?? [];
    } catch (Exception $e) {
        echo "<script>alert('Error fetching Google Sheet: " . addslashes($e->getMessage()) . "');</script>";
        return [];
    }
}

// ✅ Example usage

$sheetName = "Dean's List";
$values = getGoogleSheetData($gsid, $sheetName);
?>