<?php
require __DIR__ . '/google_client_helper.php';

/**
 * Delete a Google Sheet tab by its sheet ID.
 *
 * @param string $spreadsheetId The Google Sheet ID
 * @param int $sheetId The Sheet tab ID
 * @return array ['success'=>true] or ['error'=>message]
 */
function deleteSheetTabById($spreadsheetId, $sheetId) {
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    $deleteRequest = new Google_Service_Sheets_DeleteSheetRequest([
        'sheetId' => $sheetId
    ]);

    $batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
        'requests' => [['deleteSheet' => $deleteRequest]]
    ]);

    try {
        $service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);
        return ['success' => true];
    } catch (Exception $e) {
        return ['error' => $e->getMessage()];
    }
}
?>
