<?php
require __DIR__ . '/google_client_helper.php';

function copySheetTab($spreadsheetId, $sourceSheetName, $newSheetName) {
    $client = getGoogleClient();
    $service = new Google_Service_Sheets($client);

    // 1. Get spreadsheet metadata
    $spreadsheet = $service->spreadsheets->get($spreadsheetId);
    $sheets = $spreadsheet->getSheets();

    $sourceSheetId = null;

    // 2. Look for source sheet and check if target exists
    foreach ($sheets as $sheet) {
        $props = $sheet->getProperties();

        if ($props->getTitle() === $newSheetName) {
            return ["error" => "A sheet with that name already exists."];
        }

        if ($props->getTitle() === $sourceSheetName) {
            $sourceSheetId = $props->getSheetId();
        }
    }

    if (!$sourceSheetId) {
        return ["error" => "Source sheet '$sourceSheetName' not found."];
    }

    // 3. Duplicate sheet
    $duplicateRequest = new Google_Service_Sheets_DuplicateSheetRequest([
        "sourceSheetId" => $sourceSheetId,
        "insertSheetIndex" => count($sheets),
        "newSheetName" => $newSheetName
    ]);

    $batchRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
        "requests" => [
            ["duplicateSheet" => $duplicateRequest]
        ]
    ]);

    try {
        $response = $service->spreadsheets->batchUpdate($spreadsheetId, $batchRequest);

        // Response contains the sheetId of the newly created tab
        $newSheetId = $response->getReplies()[0]["duplicateSheet"]["properties"]["sheetId"];

        return [
            "sheetId" => $newSheetId,
            "sheetName" => $newSheetName,
            "success" => true
        ];

    } catch (Exception $e) {
        return ["error" => "Google API error: " . $e->getMessage()];
    }
}
?>
