<?php
require_once __DIR__ . '/google_client_helper.php';

function copyGoogleSheet($filename, $gsid) {
    try {
        $client = getGoogleClient();
        $driveService = new Google_Service_Drive($client);

        $sourceFileId = $gsid; // your template sheet ID
        $copyMetadata = new Google_Service_Drive_DriveFile([
            'name' => $filename ?: 'Unnamed File'
        ]);

        $copiedFile = $driveService->files->copy($sourceFileId, $copyMetadata);
        return $copiedFile->id ?? null;
    } catch (Exception $e) {
        error_log("Google API copy error: " . $e->getMessage());
        return null;
    }
}
