<?php
require __DIR__ . '/vendor/autoload.php';

function getGoogleClient(): Google_Client {
    $client = new Google_Client();
    $client->setAuthConfig('client_secret_1045766898749-1ph0oeqnvldo2j7srgaebm7i0p33it1a.apps.googleusercontent.com.json');
    $client->setRedirectUri('https://sscprojects.site/ccs/oauth2callback.php');
    $client->addScope(Google_Service_Sheets::SPREADSHEETS);
    $client->addScope(Google_Service_Drive::DRIVE);
    $client->setAccessType('offline');
    $client->setPrompt('consent'); // ensures refresh token at least once

    if (!file_exists('token.json')) {
        throw new Exception("Missing token.json. Please authenticate first.");
    }

    $accessToken = json_decode(file_get_contents('token.json'), true);
    $client->setAccessToken($accessToken);

    if ($client->isAccessTokenExpired()) {
        if ($client->getRefreshToken()) {
            $newToken = $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
            $mergedToken = array_merge($accessToken, $newToken);
            file_put_contents('token.json', json_encode($mergedToken));
            $client->setAccessToken($mergedToken);
        } else {
            // no refresh token → must re-auth
            unlink('token.json');
            throw new Exception("Google token expired. Please re-authenticate.");
        }
    }

    return $client;
}
