<?php

    function formatName($name){
        $parts = explode(',', $name);
        $lastName = isset($parts[0]) ? strtoupper(trim($parts[0])) : '';
        $firstMiddle = '';
        if(isset($parts[1])){
            $words = explode(' ', trim($parts[1]));
            $words = array_map(function($w){ return ucfirst(strtolower($w)); }, $words);
            $firstMiddle = implode(' ', $words);
        }
        return $lastName . ($firstMiddle ? ', ' . $firstMiddle : '');
    }
include 'db.php'; // your DB connection




$semester = isset($_GET['semester']) ? $_GET['semester'] : 'First';
$year = isset($_GET['year']) ? $_GET['year'] : '2025 - 2026';
$program = isset($_GET['program']) ? $_GET['program'] : 'BS IT';

// Fetch records for selected semester and year
$stmt = $conn->prepare("
 SELECT CONCAT(student_info.LASTNAME, ', ', student_info.FIRSTNAME, ' ', student_info.MIDDLENAME) AS Fullname,
       program.PROGRAM,
       student_info.STUDENT_ID,
       section.YEAR_SECTION,
       deans_list.GWA
FROM deans_list
JOIN section ON deans_list.SECTION_ID = section.SECTION_ID
JOIN program ON section.PROGRAM_ID = program.PROGRAM_ID
JOIN student_info ON deans_list.LRN_NO = student_info.LRN_NO
WHERE section.SEMESTER = ? 
  AND section.SCHOOL_YEAR = ?
  AND program.PROGRAM=?
ORDER BY deans_list.GWA DESC;

");
$stmt->bind_param("sss", $semester, $year, $program);
$stmt->execute();
$result = $stmt->get_result();
include_once 'calc_grades.php';
$rank = 1;
if ($result->num_rows > 0) {
  while ($row = $result->fetch_assoc()) {
echo "<tr>
        <td>{$rank}</td>
        <td>
            <a onclick=\"return confirm('If the page keeps loading for more than 1 minute, return to this page and try again.');\" 
               style='text-decoration:none; color:#000' 
               href='students_record.php?id=" . htmlspecialchars($row['STUDENT_ID']) . "'>
               " . htmlspecialchars(formatName($row['Fullname'])) . ".
            </a>
        </td>
        <td style='text-align: center'>" . htmlspecialchars($row['PROGRAM']) . " " . htmlspecialchars($row['YEAR_SECTION']) . "</td>
        <td style='text-align: center'>" . htmlspecialchars(number_format(calc_grade($row['GWA']), 2)) . "</td>
      </tr>";

    $rank++;
  }
} else {
  echo "<tr><td colspan='4' style='text-align:center;'>No records found for {$semester} Semester, {$year}.</td></tr>";
}

$stmt->close();
$conn->close();
?>
