<?php
session_start();

if (!isset($_SESSION['ID'])) {
    header('Location: login.php');
    exit();
}

include 'db.php';

if (isset($_GET['Id']) && isset($_GET['filepath'])) {
    $id = $_GET['Id'];
    $path = $_GET['filepath'];

    $stmt = $conn->prepare("DELETE FROM user WHERE USER_ID = ?");
    if ($stmt) {
        $stmt->bind_param("s", $id);

        if ($stmt->execute()) {
            // Delete image file if not default
            if ($path !== "assets/images/c3.png" && file_exists($path)) {
                unlink($path);
            }

            $stmt->close();
            $conn->close();

            // ✅ Redirect back with deleted=1 flag
            // If you came from users.php, this will show SweetAlert "Deleted!" there
            $ref = $_SERVER['HTTP_REFERER'] ?? 'users.php';
            $sep = (strpos($ref, '?') !== false) ? '&' : '?';
            header("Location: " . $ref . $sep . "deleted=1");
            exit();
        } else {
            echo "<script>
                alert('Error executing query: " . addslashes($stmt->error) . "');
                history.back();
            </script>";
        }

        $stmt->close();
    } else {
        echo "<script>
            alert('Error preparing statement: " . addslashes($conn->error) . "');
            history.back();
        </script>";
    }

    $conn->close();
} else {
    header('Location: users.php');
    exit();
}
?>
