<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (isset($_GET['id'])) {
    include 'db.php';
    $id = intval($_GET['id']);

    // Get GSID
    $stmt = $conn->prepare("SELECT GSID FROM section WHERE SECTION_ID = ?");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $stmt->bind_result($fileid);
    $stmt->fetch();
    $stmt->close();
    $fileid = $fileid ?: 'Unknown';

    // Get CLASS_ID
    $stmt = $conn->prepare("SELECT CLASS_ID FROM classes WHERE SECTION_ID = ?");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $stmt->bind_result($classid);
    $stmt->fetch();
    $stmt->close();
    $classid = $classid ?: 'Unknown';

    // Delete Google Sheet
    require_once 'gs_delete_google_sheet_file.php';
    try {
        $del = deleteGoogleSheet($fileid);
        if (!$del) {
            throw new Exception("Error file ID.");
        }
    } catch (Exception $e) {
        die("Google API Error: " . $e->getMessage());
    }

    // Delete from database
    $stmt = $conn->prepare("DELETE FROM section WHERE SECTION_ID = ?");
    $stmt->bind_param("i", $id);

    $stmt1 = $conn->prepare("DELETE FROM classes WHERE SECTION_ID = ?");
    $stmt1->bind_param("s", $id);

    $stmt2 = $conn->prepare("DELETE FROM enrollment WHERE CLASS_ID = ?");
    $stmt2->bind_param("s", $classid);

    if ($stmt->execute() && $stmt1->execute() && $stmt2->execute()) {
        echo "<script>
            alert('Successfully Deleted.');
            setTimeout(() => {
                if (document.referrer) {
                    window.location.href = document.referrer;
                } else {
                    window.location.href = 'main.php?page=section';
                }
            }, 1000);
        </script>";
    } else {
        echo "<script>
            alert('Failed to remove section.');
            setTimeout(() => {
                if (document.referrer) {
                    window.location.href = document.referrer;
                } else {
                    window.location.href = 'main.php?page=section';
                }
            }, 1500);
        </script>";
    }

    $stmt->close();
    $stmt1->close();
    $stmt2->close();
}

$conn->close();
?>
