<?php
session_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

$prev = $_SERVER['HTTP_REFERER'] ?? 'section.php'; 

if (!isset($_GET['id'])) {
    header("Location: $prev");
    exit();
}

include 'db.php';
$id = intval($_GET['id']);

// 1. Fetch GSID and sheet_tab_id
$stmt = $conn->prepare("SELECT SECTION_ID, SHEET_TAB_ID, SUBJECT_ID FROM classes WHERE CLASS_ID = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($sec_id, $sheet_tab_id, $sub_id);
$stmt->fetch();
$stmt->close();

$sec_id = $sec_id ?: 0;
$sheet_tab_id = $sheet_tab_id ?: 0;
$sub_id = $sub_id ?: 0;

// 2. Fetch GSID from section
$stmt = $conn->prepare("SELECT GSID FROM section WHERE SECTION_ID = ?");
$stmt->bind_param("i", $sec_id);
$stmt->execute();
$stmt->bind_result($gsid);
$stmt->fetch();
$stmt->close();
$gsid = $gsid ?: '';

// 3. Delete Google Sheet tab if sheet_tab_id exists
if (!empty($gsid) && !empty($sheet_tab_id)) {
    require_once 'gs_delete_sheet_tab.php';
    $result = deleteSheetTabById($gsid, $sheet_tab_id);
}

// 4. Delete class from DB
$stmt = $conn->prepare("DELETE FROM classes WHERE CLASS_ID = ?");
$stmt->bind_param("i", $id);
$success = $stmt->execute();
$stmt->close();
$conn->close();

// 5. Redirect back with feedback
$deleted_param = $success ? "1" : "0";
header("Location: $prev?deleted=$deleted_param");
exit();
?>
