<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Rank List - Printable</title>
<link rel="icon" href="assets/images/favicon.ico" type="image/x-icon">

<style>
/* Make all tables responsive on screen */
@media screen {
  table {
    width: 100%;
    max-width: 100%;
    overflow-wrap: break-word;
    word-break: break-word;
  }

  .sheet table {
    transform-origin: top center;
    transform: scale(0.98);
  }
}

/* On print: perfect size */
@media print {
  .sheet table {
    transform: scale(1) !important;
  }
}

@page { size: 8in 12in; margin: 0.1in; }

.to_address { font-weight: bold; font-size: 14px; }
u { font-weight: bold; }
html, body { height: 100%; margin: 0; padding: 0; font-family: "Times New Roman", serif; color: #111; }

.sheet {
  box-sizing: border-box;
  width: 100%;
  max-width: 8in;
  min-height: 13in;
  margin: 5px auto;
  padding: 5px;
  background: white;
  -webkit-print-color-adjust: exact;
  transform-origin: top center;
}

header.report-header { text-align: center; margin-bottom: 2px; }
header.report-header img { display: block; margin: 0 auto 10px; width: 85%; height: auto; }
header.report-header h1 { font-size: 20px; margin: 10px 0 5px 0; }
header.report-header p.sub { margin: 0; font-size: 13px; color: #333; }

table.rank-table { width: 100%; border-collapse: collapse; table-layout: fixed; font-size: 11pt; }
table.rank-table thead th {
  padding: 10px 8px;
  background: #1E90FF;
  color: white;
  text-align: left;
  font-weight: 600;
  border: 1px solid #0f6fbf;
}
table.rank-table tbody td { padding: 8px 8px; border: 1px solid #ddd; vertical-align: middle; word-wrap: break-word; }

.col-rank { width: 10%; }
.col-name { width: 50%; }
.col-year { width: 20%; }
.col-gwa  { width: 20%; text-align: center; }

table.rank-table tbody tr:nth-child(even) { background: #fbfdff; }
table.rank-table tr { page-break-inside: avoid; }

@media screen {
  .print-controls { margin-bottom: 12px; }
  .sheet { transform: scale(0.95); margin-top: 20px; }
  body { overflow-x: hidden; padding: 5px; }
}

@media print {
    #addLineBtn { 
    display: none !important; 
  }
  .print-controls, .filter-bar { display: none !important; }
  body * { visibility: hidden; }
  .sheet, .sheet * { visibility: visible; position: static; }
  .sheet { position: absolute; left: 0; top: 0; width: 100%; margin: 5px; padding: 0.2in; border: none !important; box-shadow: none !important; }
  body { background: white !important; }
  thead { display: table-header-group; }
  tbody::before { content: ""; display: block; height: 0.1in; }
}

.filter-bar { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; font-size: 13px; margin-bottom: 10px; }
.filter-bar select { margin: 0 6px; padding: 6px 12px; border: 1px solid #ccc; border-radius: 5px; font-size: 13px; font-weight: bold; background: #fff; cursor: pointer; }
.filter-bar a { margin: 0 6px; padding: 6px 12px; border-radius: 5px; font-size: 13px; font-weight: bold; cursor: pointer; background: #1E90FF; color: white; text-decoration: none; white-space: nowrap; }
.filter-bar a:hover { background: #0056b3; }
.filter-bar a.active { background: #104E8B; }

@media (max-width: 600px) {
  .filter-bar { flex-direction: column; align-items: flex-start; gap: 6px; }
}

.btn {
  padding: 10px 20px;
  border-radius: 5px;
  color: #000;
  border: 0;
  cursor: pointer;
  background-color: #cfe8ff;
  transition: background-color 0.3s ease, transform 0.2s ease, box-shadow 0.3s ease;
}
.btn:hover {
  background-color: #8fc6ff;
  transform: scale(1.05);
  box-shadow: 0 4px 15px rgba(143, 198, 255, 0.6);
}

.sub { font-size: 13px !important; }
.clerk { border:0; text-decoration: underline; font-family: "Times New Roman", serif; text-align: center; font-weight: bold; font-size: 13px; text-transform: uppercase; width: 100%; }
table.personel tbody td{ font-size:13px; }

#term-label, #year-term-label { font-weight: bold; text-decoration: underline; }
</style>
</head>

<body>
<?php 
$prev = $_SERVER['HTTP_REFERER'] ?? 'index.php'; 
include 'db.php';

// Get current school year info once
$current = mysqli_query($conn, "SELECT * FROM school_year WHERE CURRENT = 'Yes' LIMIT 1");
$sy = mysqli_fetch_assoc($current) ?? ['Dean' => 'No Dean Found', 'Deans_greetings' => 'Nothing found'];
?>
<div class="sheet">
  <div class="print-controls">
    <button class="btn" onclick="window.location.href='index.php'">Go to Home</button>
    <button class="btn" onclick="window.location.href='deans_list_grouped.php'">View by Program</button>
    <button class="btn" onclick="window.print()">Print / Save as PDF</button>
  </div>

  <header class="report-header">
    <img src="assets/images/header.png" alt="School Logo" style="max-width:100%; width:850px; height:auto; "/>
    <p style="text-align:left; padding:0 10px">
      <?php echo date('M d, Y'); ?><br>
      <b class="to_address"><?php echo htmlspecialchars($sy['Dean']); ?></b><br>
      Dean of Student Affairs<br>
      Sulu State College<br>
      Jolo, Sulu<br><br>
      <?php echo htmlspecialchars($sy['Deans_greetings']).','; ?><br>
      Assalamualaykum Warahmatullahi Taula Wabarakatuhu...<br><br>
      The undersigned respectfully submits the list of Rank&apos;s Lister students from the College of Computing Studies 
      for Academic Year <span id="year-label"><?php echo date('Y'); ?></span>, to wit:
    </p>

    <h1>Rank List</h1>

    <div class="filter-bar">
      <i>Filter Results here:</i>
      <select id="school-year">
        <?php
        $currentYears = mysqli_query($conn, "SELECT * FROM school_year WHERE CURRENT = 'Yes' ORDER BY SCHOOL_YEAR DESC");
        while ($row = mysqli_fetch_assoc($currentYears)) {
          echo "<option selected value='{$row['SCHOOL_YEAR']}'>{$row['SCHOOL_YEAR']}</option>";
        }
        $otherYears = mysqli_query($conn, "SELECT * FROM school_year WHERE CURRENT <> 'Yes' ORDER BY SCHOOL_YEAR DESC");
        while ($row = mysqli_fetch_assoc($otherYears)) {
          echo "<option value='{$row['SCHOOL_YEAR']}'>{$row['SCHOOL_YEAR']}</option>";
        }
        mysqli_close($conn);
        ?>
      </select>

      <a href="#" class="sem-link active" data-sem="First">1st Sem</a>
      <a href="#" class="sem-link" data-sem="Second">2nd Sem</a><br>
      <i style="color: green"><b>Note:</b> You can view records by clicking student names.</i>
    </div>

    <p class="sub">
      School Year: <span id="year-term-label">2024 - 2025</span> &nbsp;&nbsp; 
      Term: <span id="term-label">1st Semester</span>
    </p>
  </header>

  <!-- Table 1 with Add Line button -->
  <div id="table1-container">
    <table class="rank-table">
      <thead>
        <tr>
          <th class="col-rank">Rank</th>
          <th class="col-name">Name</th>
          <th class="col-year" style="text-align: center">Year & Section</th>
          <th class="col-gwa" style="text-align: center">GWA</th>
        </tr>
      </thead>
      <tbody id="rankTableBody"></tbody>
    </table>

    <button class="btn" id="addLineBtn" style="margin-top:10px;" title="Add a New Line to fix format when printing">+</button>
  </div>
  
<table style="width:100%;border-collapse:collapse;margin-top:40px;" class="personel">
    <tr>
      <td style="text-align:center;padding-bottom:20px;">
        <b>Prepared by:</b><br><br><br>
        <input type="text" value="NUR-AIN J. IBNO" name="clerk" class="clerk"><br>
        Clerk
      </td>
    </tr>
    <tr><td></td></tr>
    <tr>
      <td style="text-align:center;padding-bottom:30px;">
        <b>Checked by:</b><br><br><br>
        <table style="width:100%;border-collapse:collapse;">
          <tr>
            <td style="text-align:center;" colspan="2" >
              <u>ASST.PROF.&nbsp;VIC&nbsp;&nbsp;ZAPATA,&nbsp;&nbsp;MSCS</u><br>
              Department Head,&nbsp;BSCS
            </td>
          </tr>
          
          <tr><td>&nbsp;</td></tr>
          <tr><td colspan="2" style="height:20px;"></td></tr>
          <tr>
            <td style="text-align:center; padding:20px">
              <u>ASST.&nbsp;PROF.&nbsp;ALNAHAR&nbsp;A.&nbsp;AMIRUL&nbsp;DPA,&nbsp;MIT,&nbsp; PCpE</u><br>
              Department Head,&nbsp;BSIS
            </td>
            <td style="text-align:center; padding:20px">
              <u>PROF.&nbsp;JEHANA&nbsp;A.&nbsp;DARKIS,&nbsp;Ed.D,&nbsp;PCpE,&nbsp;DIT-CAR</u><br>
              Department Head,&nbsp;BSIT
            </td>
          </tr>
        </table>
      </td>
    </tr>
    <tr>
      <td style="text-align:center;padding-top:20px;">
        <table style="width:100%;border-collapse:collapse;">
          <tr>
            <td><b>Noted by:</b><br></td>
            <td><b>Approved by:</b><br></td>
          </tr>
          <tr>
            <td style="text-align:center; padding:20px">
              <u>PROF.&nbsp;ALDARUHZ&nbsp;T.&nbsp;DARKIS,&nbsp;DPA,&nbsp;DIT-CAR</u><br>
              Dean,&nbsp;CCS
            </td>
            <td style=";text-align:center; padding:20px">
              <u>ENGR. FIRASH&nbsp;ZHED&nbsp;S.&nbsp;UTUTALUM, M-SC.</u><br>
              Dean&nbsp;of&nbsp;Student&nbsp;Affairs
            </td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
<br><br>
<footer class="page-footer">
  <img src="assets/images/deanlist-footer.png" alt="School Footer" style="max-width:100%; width:850px; height:auto;"/>
  <span class="page-number"></span>
</footer>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
  const links = document.querySelectorAll('.sem-link');
  const tbody = document.getElementById('rankTableBody');
  const yearSelect = document.getElementById('school-year');
  const yearLabel = document.getElementById('year-label');
  const yearTermLabel = document.getElementById('year-term-label');
  const termLabel = document.getElementById('term-label');

  let currentSem = 'First';
  let currentYear = yearSelect.value;

  function loadRecords(sem, year) {
    links.forEach(link => link.classList.remove('active'));
    document.querySelector(`.sem-link[data-sem="${sem}"]`).classList.add('active');
    termLabel.textContent = `${sem} Semester`;
    yearLabel.textContent = year;
    yearTermLabel.textContent = year;

    fetch(`fetch_ranklist.php?semester=${encodeURIComponent(sem)}&year=${encodeURIComponent(year)}`)
      .then(res => res.text())
      .then(data => { tbody.innerHTML = data; });
  }

  loadRecords(currentSem, currentYear);

  links.forEach(link => {
    link.addEventListener('click', e => {
      e.preventDefault();
      currentSem = link.dataset.sem;
      loadRecords(currentSem, currentYear);
    });
  });

  yearSelect.addEventListener('change', e => {
    currentYear = e.target.value;
    loadRecords(currentSem, currentYear);
  });

  // Add new line button functionality
  document.getElementById('addLineBtn').addEventListener('click', () => {
    const tableContainer = document.getElementById('table1-container');
    const newLine = document.createElement('div');
    newLine.style.height = '20px'; // Adjust spacing
    tableContainer.appendChild(newLine);
  });
});
</script>
</body>
</html>
