<?php 
	include 'db.php';

	if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        if (isset($_POST['add_curr'])) {
		$errors = array();

		// Validation
		if (preg_match("/\S+/", $_POST['cur']) === 0) {
			$errors['cur'] = "* Program is required.";
		}
		if (preg_match("/\S+/", $_POST['des']) === 0) {
			$errors['des'] = "* Description is required.";
		}

		if (count($errors) === 0) {
			// Sanitize input
			$cur = mysqli_real_escape_string($conn, $_POST['cur']);
			$des = mysqli_real_escape_string($conn, $_POST['des']);
			$user = $_SESSION['ID'];

            $existence = $conn->prepare("SELECT * FROM program WHERE PROGRAM=?");
            $existence->bind_param("s", $cur);
            $existence->execute();
            $existence->store_result();
            
            
			if (empty($_POST['id'])) {
				$sql = "INSERT INTO program (PROGRAM, DESCRIPTION) VALUES ('$cur', '$des')";
			} else {
				$id = (int)$_POST['id']; // cast to int for security
				$sql = "UPDATE program SET PROGRAM='$cur', DESCRIPTION='$des' WHERE PROGRAM_ID = $id";
			}
            if ($existence->num_rows == 0) {
    			if (mysqli_query($conn, $sql)) {

    		$alert = 
            "<script>
            showAlert('success', 'Saved!', 'Program successfully saved');
            setTimeout(() => window.location.href = 'curriculum_list.php', 2000);
            </script>";
            
    			} else {

                $alert = "
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        showAlert('error', 'Error!', 'Failed to save program');
                        setTimeout(() => window.location.href = 'curriculum_list.php', 3000);
                    });
                </script>";
    			}
            }else{
            $alert = "
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        showAlert('warning', 'Failed to save!', 'Program already exists');
                        setTimeout(() => window.location.href = 'curriculum_list.php', 3000);
                    });
                </script>"; }
		} else {
			// Optionally output validation errors
			foreach ($errors as $err) {
				echo "<script>alert('" . addslashes($err) . "');</script>";
			}
		}
	}
}
	mysqli_close($conn);
?>