<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('includes/header.php'); ?>
    <!-- Favicon icon -->
    <?php include('includes/stylesheets.php'); ?>
</head>

<body>
    <?php include('includes/loader.php'); ?>
    <div id="pcoded" class="pcoded">
        <div class="pcoded-overlay-box"></div>
        <div class="pcoded-container navbar-wrapper">

            <?php include('includes/topnavbar.php'); ?>
            <div class="pcoded-main-container">
                <div class="pcoded-wrapper">
                    <?php
                    include 'db.php';

                    $sql = mysqli_query($conn, "SELECT * FROM user where USER_ID = '" . $_SESSION['ID'] . "'");
                    $row = mysqli_fetch_assoc($sql);
                        $accesstype = $row['USER_TYPE'] ?? 'Staff';
                        if ($accesstype == 'ADMINISTRATOR') {
                            include 'includes/sidebar.php';
                        } else {
                            include 'includes/sidebar_faculty.php';
                        }
                        ?>

                    <div class="pcoded-content">
                        <!-- Page-header start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">Academics</h5>
                                            <p class="m-b-0">Explore the subjects, programs offered by
                                                the institution.</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item">
                                                <a href="index.html"> <i class="fa fa-home"></i> </a>
                                            </li>
                                            <li class="breadcrumb-item"><a href="#!">Program List</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Page-header end -->

                        <div class="pcoded-inner-content">
                            <!-- Main-body start -->
                            <div class="main-body">
                                <div class="page-wrapper">
                                    <!-- Page body start -->
                                    <div class="page-body">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>List of Programs</h5>
                                                        <span>To modify a <code>Program, </code> directly change the
                                                            content on the table then click update icon
                                                            <code><i class="fa fa-pencil" aria-hidden="true"></i> - pencil</code></span>
                                                        <?php
                                                        include 'curriculum_list_exe.php';
                                                        ?>
                                                        <script>
                                                            $(document).ready(function () {

                                                                $(document).on('click', '#get_sub', function (e) {

                                                                    e.preventDefault();

                                                                    var prog = $(this).data('id');
                                                                    $.ajax({
                                                                        url: 'get_subject.php',
                                                                        type: 'POST',
                                                                        data: 'prog=' + prog,
                                                                        beforeSend: function () {
                                                                            $("#content").html('Working on Please wait ..');
                                                                        },
                                                                        success: function (data) {
                                                                            $("#content").html(data);
                                                                        },
                                                                    })

                                                                });
                                                            })
                                                        </script>
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="table-responsive">



                                                            <div class="panel panel-default">
                                                                <div class="panel-heading">
                                                                    <!--<h3 class="panel-title"></h3>-->
                                                                </div>
                                                                <div class="panel-body">
                                                                    <table class="table table-hover table-bordered">
                                                                        <thead>
                                                                            <tr id="heads">
                                                                                <th style="width:10%">Program</th>
                                                                                <th style="width:30%">Description</th>
                                                                                <th style="width:20%"></th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                            include_once 'curriculum_update.php';
                                                                            include 'db.php';
                                                                            
                                                                            $sql = mysqli_query($conn, "SELECT * FROM program Order by PROGRAM");
                                                                            while ($row = mysqli_fetch_assoc($sql)) { ?>
                                                                                <form method="post">
                                                                                    <tr>
                                                                                        <input type="hidden" name="id"
                                                                                            value="<?php echo $row['PROGRAM_ID'] ?>">
                                                                                        <td><input name="prog" type="text"
                                                                                                style="border:0px; background-color:transparent"
                                                                                                value="<?php echo $row['PROGRAM'] ?>">
                                                                                        </td>
                                                                                        <td><textarea name="desc"
                                                                                                type="text"
                                                                                                style="border:0px; background-color:transparent; width:100%"><?php echo $row['DESCRIPTION'] ?></textarea>
                                                                                        </td>
                                                                                        <td><a class="badge btn-success text-white"
                                                                                                data-toggle="modal"
                                                                                                data-target="#program"
                                                                                                title="Subjects"
                                                                                                data-id="<?php echo $row['PROGRAM_ID'] ?>"
                                                                                                id="get_sub"><i
                                                                                                    class="fa fa-star"
                                                                                                    aria-hidden="true"></i> View Subjects</a>
                                                                                            <button type="submit"
                                                                                                name="update_curr"
                                                                                                title="Update"
                                                                                                class=" badge btn-warning" style="border:none"><i
                                                                                                    class="fa fa-pencil"
                                                                                                    aria-hidden="true"></i> Modify Info
                                                                                            </button>
                                                                                        </td>
                                                                                    </tr>
                                                                                </form>
                                                                                <?php
                                                                            }
                                                                            mysqli_close($conn);
                                                                            ?>

                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>Add New Program</h5>
                                                        <!--<span>Add class of <code>.form-control</code> with <code>&lt;input&gt;</code> tag</span>-->
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="container frm-new">
                                                            <div class="row main">
                                                                <div class="main-login main-center">
                                                                    <!--<h3 id="head"></h3>-->
                                                                    <form class="" method="post">
                                                                        <input type="hidden" name="id">
                                                                        <div class="form-group">
                                                                            <label for="sub"
                                                                                class="cols-sm-2 control-label">Program</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <input type="text"
                                                                                        class="form-control" name="cur"
                                                                                        id="sub"
                                                                                        placeholder="Enter Program"
                                                                                        value="<?php if (isset($_POST['cur'])) {
                                                                                            echo $_POST['cur'];
                                                                                        } ?>" />
                                                                                    <p>
                                                                                        <?php if (isset($errors['cur'])) {
                                                                                            echo "<br><br><div class='erlert'><h5>" . $errors['cur'] . "</h5></div>";
                                                                                        } ?>
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="form-group">
                                                                            <label for="des"
                                                                                class="cols-sm-2 control-label">Description</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <textarea type="text"
                                                                                        class="form-control" name="des"
                                                                                        id="des"
                                                                                        placeholder="Enter Description"
                                                                                        value="<?php if (isset($_POST['des'])) {
                                                                                            echo $_POST['des'];
                                                                                        } ?>"></textarea>
                                                                                    <p>
                                                                                        <?php if (isset($errors['des'])) {
                                                                                            echo "<br><br><br><div class='erlert'><h5>" . $errors['des'] . "</h5></div>";
                                                                                        } ?>
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>


                                                                        <div class="form-group ">
                                                                            <input type="reset" class="btn btn-danger"
                                                                                id="reset" name="reset" value="Cancel">
                                                                            <button class="btn btn-info"
                                                                                id="submit" name="add_curr">Add</button>
                                                                        </div>

                                                                    </form>
                                                                </div>
                                                            </div>

                                                            <div class="modal fade" id="program" role="dialog">
                                                                <div class="modal-dialog modal-md">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title">Subjects</h4>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="container">
                                                                                <div id="content"></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                class="btn btn-success"
                                                                                data-dismiss="modal">Close</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                        </div>

                                                    </div>




                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                                <!-- Page body end -->
                            </div>

                        </div>

                        <!-- Main-body end -->
                        <div id="styleSelector">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>


    <script>
        var slideIndex = 0;
        showSlides();

        function showSlides() {
            var i;
            var slides = document.getElementsByClassName("mySlides");
            var dots = document.getElementsByClassName("dot");
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            slideIndex++;
            if (slideIndex > slides.length) { slideIndex = 1 }
            for (i = 0; i < dots.length; i++) {
                dots[i].className = dots[i].className.replace(" active", "");
            }
            slides[slideIndex - 1].style.display = "block";
            dots[slideIndex - 1].className += " active";
            setTimeout(showSlides, 5000); // Change image every 2 seconds
        }
    </script>
    <script src="assets/js/ie10-viewport-bug-workaround.js"></script>
    <?php include('includes/javascripts.php'); ?>
</body>

</html>