 <?php
if (isset($_GET['id'])) {
    $sec_id = intval($_GET['id']) ?? '0';
 ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include('includes/header.php'); ?>
    <!-- Favicon icon -->
    <?php include('includes/stylesheets.php'); ?>
    <style>td a{
    margin:3px;
    }
    .link-padding{border:none !important; padding: 6px !important; cursor: pointer; margin-bottom: 5px;}
    /* ===== Modal Styles ===== */

    </style>
    <link rel="stylesheet" type="text/css" href="assets/css/popupmodal.css">

</head>

<body>
    <?php include('includes/loader.php'); ?>
    <div id="pcoded" class="pcoded">
        <div class="pcoded-overlay-box"></div>
        <div class="pcoded-container navbar-wrapper">

            <?php include('includes/topnavbar.php'); ?>
            <div class="pcoded-main-container">
                <div class="pcoded-wrapper">
                    <?php
                    include 'db.php';

                    $sql = mysqli_query($conn, "SELECT * FROM user where USER_ID = '" . $_SESSION['ID'] . "'");
                    $row = mysqli_fetch_assoc($sql);
                        $accesstype = $row['USER_TYPE'] ?? 'Staff';
                        if ($accesstype == 'ADMINISTRATOR') {
                            include 'includes/sidebar.php';
                        } else {
                            include 'includes/sidebar_faculty.php';
                        }
                        
            // Get  GSID
            $stmt = $conn->prepare("SELECT GSID, SCHOOL_YEAR, YEAR_SECTION, SEMESTER, PROGRAM_ID FROM section WHERE SECTION_ID = ?");
            $stmt->bind_param("i", $sec_id);
            $stmt->execute();
            $stmt->bind_result($gsid, $sy, $ys, $sem, $progid);
            $stmt->fetch();
            $stmt->close();
            
            $gsid = $gsid ?: 'Unknown';
            $sy = $sy ?: 'Unknown';
            $ys = $ys ?: 'Unknown';
            $semester = $sem.' Semester' ?: 'Unknown';
            $progid = $progid ?: 'Unknown';
            
            
            $stmt = $conn->prepare("SELECT PROGRAM from program WHERE PROGRAM_ID = ?");
            $stmt->bind_param("i", $progid);
            $stmt->execute();
            $stmt->bind_result($programname);
            $stmt->fetch();
            $stmt->close();
            
            $programname=$programname ?: 'Unknown';
            ?>
                    <div class="pcoded-content">
                        <!-- Page-header start -->
                        <div class="page-header">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-8">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10">Class</h5>
                                            <p class="m-b-0">Below is the list of all available classes along with their
                                                details. You can view, edit, or manage each class.</p>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <ul class="breadcrumb">
                                            <li class="breadcrumb-item">
                                                <a href="index.html"> <i class="fa fa-home"></i> </a>
                                            </li>
                                            <li class="breadcrumb-item"><a href="#!">Class List </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Page-header end -->

                        <div class="pcoded-inner-content">
                            <!-- Main-body start -->
                            <div class="main-body">
                                <div class="page-wrapper">
                                    <!-- Page body start -->
                                    <div class="page-body">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>Classes in: <?php echo $programname.' '.$ys.' ('.$sy.') - '.$semester; ?> </h5>
                                                        <span><code>Deleting classes <i class="fa fa-trash" aria-hidden="true"></i></code> may impact records that depend on this table — proceed with caution.</span>
                                                        <?php
                                                        include 'classes_exe.php';
                                                        
                                                        require_once 'gs_view_sheet_tab.php';

                                                        ?>
                                                       
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="table-responsive">
                                                      <button class="generateBtn badge link-padding text-white btn-info" data-id="<?php echo $gsid?>"><i class="fa fa-list"></i> Generate Rank List</button>
                                                      <button id="openModal" class="badge link-padding text-white btn-primary"><i class="fa fa-trophy"></i> Show Rank List</button>
                                                      <div id="result"></div> 
                                                        <br>
                                                            <div class="panel panel-default">
                                                                <div class="panel-heading">
                                                                    <!--<h3 class="panel-title"></h3>-->
                                                                </div>
                                                                <div class="panel-body">
                                                                    <table class="table table-hover table-bordered"
                                                                        id="classes">
                                                                        <thead>
                                                                            <tr id="heads">
                                                                                <th style="width:15%">Subject Code</th>
                                                                                <th style="width:20%">
                                                                                   <?php echo $accesstype == 'ADMINISTRATOR'? "Instructor":"Subject Title";?>
                                                                                </th>
                                                                                <th style="width:5%">Program</th>
                                                                                <th style="width:5%">Yr Sec.</th>
                                                                                <th style="width:25%">SY</th>
                                                                                <th style="width:10%">Sem.</th>
                                                                                <th style="width:20%">Action</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <?php
                                                                            include 'db.php';
                                                                            
                                                                            if ($accesstype == 'ADMINISTRATOR') {
                                                                                $stmt = "SELECT 
                                                                                    c.CLASS_ID,
                                                                                    c.SECTION_ID,
                                                                                    c.FACULTY_ID,
                                                                                    c.SUBJECT_ID,
    
                                                                                    sctn.SCHOOL_YEAR,
                                                                                    sctn.YEAR_SECTION,
                                                                                    sctn.GSID,
                                                                                    sctn.SEMESTER,
    
                                                                                    s.SUBJECT_CODE,
                                                                                    s.DESCRIPTION,
                                                                                    s.YEAR_LEVEL,
                                                                                    s.PROGRAM_ID,
    
                                                                                    u.FIRSTNAME,
                                                                                    u.LASTNAME,
                                                                                    u.DESIGNATION,
                                                                                    u.EXPERTISE
    
                                                                                FROM 
                                                                                    classes c
                                                                                JOIN 
                                                                                    subjects s ON c.SUBJECT_ID = s.SUBJECT_ID
                                                                                JOIN 
                                                                                    section sctn ON c.SECTION_ID = sctn.SECTION_ID
                                                                                JOIN 
                                                                                    user u ON c.FACULTY_ID = u.USER_ID
                                                                                WHERE 
                                                                                    c.SECTION_ID='".$sec_id."'";
                                                                                
                                                                            }
                                                                            else
                                                                            {
                                                                               $stmt = "SELECT 
                                                                                c.CLASS_ID,
                                                                                c.SECTION_ID,
                                                                                c.FACULTY_ID,
                                                                                c.SUBJECT_ID,
                                                                    
                                                                                sctn.SCHOOL_YEAR,
                                                                                sctn.YEAR_SECTION,
                                                                                sctn.GSID,
                                                                                sctn.SEMESTER,
                                                                    
                                                                                s.SUBJECT_CODE,
                                                                                s.DESCRIPTION,
                                                                                s.YEAR_LEVEL,
                                                                                s.PROGRAM_ID,
                                                                    
                                                                                u.FIRSTNAME,
                                                                                u.LASTNAME,
                                                                                u.DESIGNATION,
                                                                                u.EXPERTISE
                                                                    
                                                                            FROM 
                                                                                classes c
                                                                            JOIN 
                                                                                subjects s ON c.SUBJECT_ID = s.SUBJECT_ID
                                                                            JOIN 
                                                                                section sctn ON c.SECTION_ID = sctn.SECTION_ID
                                                                            JOIN 
                                                                                user u ON c.FACULTY_ID = u.USER_ID
                                                                            WHERE 
                                                                                c.FACULTY_ID = '" . $_SESSION['ID'] . "' AND c.SECTION_ID='".$sec_id."'";
                                                                                
                                                                            }   
                                                                            $sql = mysqli_query($conn, $stmt);
                                                                            if (!$sql) {
                                                                                die("Query failed: " . mysqli_error($conn));
                                                                            }
                                                                            while ($row = mysqli_fetch_assoc($sql)) { ?>

                                                                                <tr>

                                                                                    <td><?php echo $row['SUBJECT_CODE']; ?>
                                                                                    </td>

                                                                                    <td>
                                                                                        <?php
                                                                                        if ($accesstype == 'ADMINISTRATOR') {
                                                                                            $stmt_faculty = "SELECT * FROM user where USER_ID='" . $row['FACULTY_ID'] . "'";
                                                                                            $sqlquery = mysqli_query($conn, $stmt_faculty);
                                                                                            while ($data = mysqli_fetch_assoc($sqlquery)) {
                                                                                                echo $data['FIRSTNAME'] . " " . $data['LASTNAME'];
                                                                                            } 
                                                                                        }else{
                                                                                          echo $row['DESCRIPTION'];
                                                                                        } ?>
                                                                                    </td>
                                                                                    <td>
                                                                                        <?php
                                                                                        $stmt_prog = "SELECT * FROM subjects, program where subjects.SUBJECT_ID='" . $row['SUBJECT_ID'] . "' and program.PROGRAM_ID=subjects.PROGRAM_ID";
                                                                                        $sql_prog = mysqli_query($conn, $stmt_prog);
                                                                                        while ($data_prog = mysqli_fetch_assoc($sql_prog)) {
                                                                                            echo $data_prog['PROGRAM'];
                                                                                        } ?>
                                                                                    </td>
                                                                                    <td><?php echo $row['YEAR_SECTION'] ?>
                                                                                    </td>

                                                                                    <td><?php echo $row['SCHOOL_YEAR'] ?>
                                                                                    </td>

                                                                                    <td><?php echo $row['SEMESTER'] ?> Sem
                                                                                    </td>
                                                                                    
                                                                                    <td>
                                                                                      <?php 
                                                                                    $spreadsheetId = $row['GSID'];
                                                                                    $link = getSheetLinkByName($spreadsheetId, $row['SUBJECT_CODE'], "preview");
                                                                                    ?>
                                                                                     <a href="#" data-id="<?php echo $row['CLASS_ID'] ?>" style="padding: 8px !important"
                                                                                        class="badge btn-info text-white open" title="Enroll Student"><i
                                                                                            class="fa fa-user-plus" aria-hidden="true"></i> Manage Class</a>
                                                                                    
                                                                                    <a title="View Grading Sheet" class="badge btn-warning text-white" style="padding: 8px !important" href="grading_sheet.php?id=<?php echo $row['CLASS_ID']; ?>">
                                                                                      <i class="fa fa-print" aria-hidden="true"></i> Grading Sheet
                                                                                    </a>                                                                                    
                                                                                    
                                                                                    <a title="View Records" class="badge btn-success text-white" style="padding: 8px !important" href="#" onclick="openSheetPopup('<?php echo $link; ?>'); return false;">
                                                                                      <i class="fa fa-file-excel-o" aria-hidden="true"></i> View Records
                                                                                    </a>
                                                                                    <a title="Remove Record" href="#" data-id="<?php echo $row['CLASS_ID']; ?>"
                                                                                            class="badge btn-danger text-white del_tab"
                                                                                            style="padding: 8px !important"><i
                                                                                                class="fa fa-trash"
                                                                                                aria-hidden="true"></i> Delete Class
                                                                                    </a>                               
                                                                                    </td>
                                                                                </tr>

                                                                                <?php
                                                                            }
                                                                            mysqli_close($conn);
                                                                            ?>

                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <script type="text/javascript">
                                                            $(function () {
                                                                $("#classes").dataTable(
                                                                    { "aaSorting": [[0, "asc"]] }
                                                                );
                                                            });
                                                        </script>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="card">
                                                    <div class="card-header">
                                                        <h5>Add New Class</h5>
                                                        <!--<span>Add class of <code>.form-control</code> with <code>&lt;input&gt;</code> tag</span>-->
                                                    </div>
                                                    <div class="card-block">
                                                        <div class="container frm-new">
                                                            <div class="row main">
                                                                <div class="main-login main-center">
                                                                    <!--<h3 id="head"></h3>-->
                                                                    <form method="post">


                                                                        <p>
                                                                            <?php if (isset($errors['program'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['program'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>

                                                                        <p>
                                                                            <?php if (isset($errors['subject'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['subject'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>

                                                                        <p>
                                                                            <?php if (isset($errors['faculty'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['faculty'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>

                                                                        <p>
                                                                            <?php if (isset($errors['section'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['section'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>
                                                                        <p>
                                                                            <?php if (isset($errors['ctime'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['ctime'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>
                                                                        <p>
                                                                            <?php if (isset($errors['cday'])) {
                                                                                echo "<div class='erlert alert-error'><h5>" . $errors['cday'] . "</h5></div>";
                                                                            } ?>
                                                                        </p>
                                                                        <div class="form-group">
                                                                            <label for="program"
                                                                                class="cols-sm-2 control-label">Program:</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <?php
                                                                                    include 'db.php';
                                                                                    // Fetch Programs
                                                                                    $res = mysqli_query($conn, "SELECT * FROM section, program where section.SECTION_ID=$sec_id and section.PROGRAM_ID=program.PROGRAM_ID");
                                                                                    $programs = [];
                                                                                    while ($row = mysqli_fetch_assoc($res)) {
                                                                                        $programs[] = $row;
                                                                                    }
                                                                                    ?>
                                                                                    <select id="program" name="program"
                                                                                        class="form-control" required>
                                                                                        <option value="">- Select
                                                                                            Program -</option>
                                                                                        <?php foreach ($programs as $p): ?>
                                                                                            <option
                                                                                                value="<?= $p['PROGRAM_ID'] ?>">
                                                                                                <?= $p['PROGRAM'] ?>
                                                                                            </option>
                                                                                        <?php endforeach; ?>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="form-group">
                                                                            <label for="section"
                                                                                class="cols-sm-2 control-label">Section:</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <select id="section" name="section" disabled class="form-control" required>
                                                                                        <option value="">- Select Section -</option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="form-group">
                                                                            <label for="subject"
                                                                                class="cols-sm-2 control-label">Subject:</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <select id="subject" name="subject"
                                                                                        required disabled
                                                                                        class="form-control">
                                                                                        <option value="">- Select
                                                                                            Subject -
                                                                                        </option>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="form-group">
                                                                            <label for="faculty"
                                                                                class="cols-sm-2 control-label">Instructor</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <select id="faculty" name="faculty"
                                                                                        style="background-color:transparent; border:0; width:100%;"
                                                                                        class="form-control" required>
                                                                                        <option value="">- Select
                                                                                                Instructor -</option>
                                                                                        <?php
                                                                                        include 'db.php';
                                                                                        if ($accesstype == 'ADMINISTRATOR') {
                                                                                        $query="SELECT * from user where USER_TYPE='FACULTY' and STATUS='Active' order by LASTNAME ASC";
                                                                                        }
                                                                                        else
                                                                                        {
                                                                                         $query="SELECT * from user where USER_TYPE='FACULTY' and STATUS='Active' and USER_ID='" . $_SESSION['ID'] . "' order by LASTNAME ASC";   
                                                                                        }
                                                                                        $stmt = mysqli_query($conn,$query);
                                                                                        while (
                                                                                            $array =
                                                                                            mysqli_fetch_assoc($stmt)
                                                                                        ) {
                                                                                            ?>
                                                                                            
                                                                                            <option
                                                                                                value="<?php echo htmlspecialchars($array['USER_ID']); ?>">
                                                                                                <?php echo htmlspecialchars($array['LASTNAME'] . ", " . $array['FIRSTNAME']); ?>

                                                                                            </option>
                                                                                        <?php } ?>
                                                                                    </select>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        
                                                                        <div class="form-group">
                                                                            <label for="section"
                                                                                class="cols-sm-2 control-label">Time:</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <input type="text" name="ctime" class="form-control" required placeholder="ex: 8:00-9:30">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group">
                                                                            <label for="section"
                                                                                class="cols-sm-2 control-label">Days:</label>
                                                                            <div class="cols-sm-4">
                                                                                <div class="input-group">
                                                                                    <input type="text" name="cday" class="form-control" required placeholder="ex: MWF">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group ">
                                                                            <input type="reset" class="btn btn-danger"
                                                                                id="reset" name="reset" value="Cancel">
                                                                            <button class="btn btn-info" id="btn_add"
                                                                                name="btn_add">Add</button>

                                                                        </div>
                                                                    </form>



                                                                </div>
                                                            </div>
                                                            <div class="modal fade" id="program" role="dialog">
                                                                <div class="modal-dialog modal-md">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title">Classes</h4>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="container">
                                                                                <div id="content"></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button"
                                                                                class="btn btn-success"
                                                                                data-dismiss="modal">Close</button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>


                                                        </div>

                                                    </div>




                                                </div>
                                            </div>

                                            <!-- Popup Modal -->
                                            <div id="sheetPopup" style="
                                              display:none;
                                              position:fixed;
                                              top:0; left:0; width:100%; height:100%;
                                              background:rgba(0,0,0,0.6);
                                              z-index:9999999;
                                            ">
                                              <div style="
                                                position:relative;
                                                width:95%; height:80%;
                                                margin:5% auto;
                                                background:#fff;
                                                border-radius:10px;
                                                overflow:hidden;
                                                box-shadow:0 4px 10px rgba(0,0,0,0.3);
                                              ">
                                                <span onclick="closeSheetPopup()" style="
                                                  position:absolute; top:10px; right:15px;
                                                  font-size:24px; cursor:pointer;
                                                ">&times;</span>
                                            
                                                <iframe id="sheetFrame"
                                                  src=""
                                                  width="100%" height="100%"
                                                  frameborder="0"></iframe>
                                              </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <!-- Page body end -->
                            </div>

                        </div>

                        <!-- Main-body end -->
                        <div id="styleSelector">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>

<!-- ✅ Modal Popup -->
<?php include 'popup_deans_list.php'; ?>
    <script>
// === Modal controls ===
document.getElementById("openModal").onclick = function() {
  document.getElementById("dataModal").style.display = "block";
};
document.getElementById("closeModal").onclick = function() {
  document.getElementById("dataModal").style.display = "none";
};
window.onclick = function(e) {
  if (e.target === document.getElementById("dataModal")) {
    document.getElementById("dataModal").style.display = "none";
  }
};
</script>
<script>
$('.generateBtn').click(function() {
    const spreadsheetId = $(this).data('id');

    // Disable button during generation
    const btn = $(this);
    btn.prop('disabled', true).text('⏳ Generating...');

    $('#result').html('⏳ Generating Dean\'s List... Please wait...');

    $.ajax({
        url: 'gs_deans_list_generator.php',
        type: 'POST',
        dataType: 'json',
        data: { 
            spreadsheetId: spreadsheetId,
            debug: 1 // ✅ optional debug flag for backend logging
        },
        success: function(res) {
            btn.prop('disabled', false).text('Generate Dean\'s List');

            if (res.status === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: '✅ Success!',
                    html: `
                        <p>${res.message}</p>
                        ${
                            res.debug 
                                ? `<pre style="text-align:left; font-size:12px; background:#f6f6f6; padding:8px; border-radius:6px; overflow-x:auto;">${JSON.stringify(res.debug, null, 2)}</pre>` 
                                : ''
                        }
                    `,
                    width: 600,
                    showConfirmButton: true,
                }).then(() => {
                    location.reload();
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: '❌ Error!',
                    text: res.message
                });
            }
        },
        error: function(xhr, status, err) {
            btn.prop('disabled', false).text('Generate Dean\'s List');
            Swal.fire({
                icon: 'error',
                title: '⚠️ AJAX Error',
                html: `
                    <b>Status:</b> ${status}<br>
                    <b>Error:</b> ${err}<br>
                    <pre style="text-align:left; font-size:12px; background:#f6f6f6; padding:8px; border-radius:6px; overflow-x:auto;">${xhr.responseText}</pre>
                `,
                width: 600
            });
        }
    });
});
</script>



    
<script>
// Get the extra ID from the current URL (e.g., ?id=123)
const urlParams = new URLSearchParams(window.location.search);
const pageId = urlParams.get("id"); // this is your extra id from the URL

document.querySelectorAll('.open').forEach(link => {
  link.addEventListener('click', function (e) {
    e.preventDefault();
    let classId = this.dataset.id; // get CLASS_ID

    // Redirect with both IDs
    if (pageId) {
      window.location.href = "student_class.php?id=" + encodeURIComponent(classId) + "&page=" + encodeURIComponent(pageId);
    } else {
      window.location.href = "student_class.php?id=" + encodeURIComponent(classId);
    }
  });
});
</script>
    
    <script>
    function openSheetPopup(link) {
        document.getElementById('sheetFrame').src = link;
        document.getElementById('sheetPopup').style.display = 'block';
    }
    function closeSheetPopup() {
        document.getElementById('sheetFrame').src = "";
        document.getElementById('sheetPopup').style.display = 'none';
    }
    </script>
    
<script>
document.querySelectorAll('.del_tab').forEach(link => {
  link.addEventListener('click', function (e) {
    e.preventDefault();
    let id = this.dataset.id;

    Swal.fire({
      title: "Are you sure?",
      text: "Deleting this will also remove related grades and records.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, Delete",
      cancelButtonText: "Cancel"
    }).then((result) => {
      if (result.isConfirmed) {
        // Redirect quietly to delete the record
        window.location.href = "delete_class.php?id=" + encodeURIComponent(id);
      }
    });
  });
});
</script>
   
<script>
const programSelect = document.getElementById("program");
const sectionSelect = document.getElementById("section");
const subjectSelect = document.getElementById("subject");

let selectedProgramId = null;
let sectionID = <?php echo json_encode($sec_id); ?>; 

// Step 1: When a program is selected, fetch sections
    programSelect.addEventListener("change", function() {
    selectedProgramId = this.value;
    // Reset section and subject selects
    sectionSelect.innerHTML = '<option value="">-- Select Section --</option>';
    sectionSelect.disabled = true;

    subjectSelect.innerHTML = '<option value="">-- Select Subject --</option>';
    subjectSelect.disabled = true;

    if (selectedProgramId) {
        fetch("get_section_by_secID.php?sec_id=" + sectionID)
            .then(res => res.json())
            .then(data => {
                if (data.length > 0) {
                    data.forEach(sec => {
                        let opt = document.createElement("option");
                        opt.value = sec.SECTION_ID;
                        opt.textContent = `${sec.YEAR_SECTION} (${sec.SCHOOL_YEAR}) ${sec.SEMESTER} Sem`;
                        sectionSelect.appendChild(opt);
                    });
                    sectionSelect.disabled = false;
                }
            })
            .catch(err => console.error("Fetch error:", err));
    }
});

// Step 2: When a section is selected, fetch subjects for that section
sectionSelect.addEventListener("change", function() {
 let sectionId = this.value;
    // Reset subjects select
    subjectSelect.innerHTML = '<option value="">-- Select Subject --</option>';
    subjectSelect.disabled = true;

    if (sectionId && selectedProgramId) {
        fetch(`programs_subjects.php?program_id=${selectedProgramId}&section_id=${sectionId}`)
            .then(res => res.json())
            .then(data => {
                console.log("Subjects fetched:", data); // debug log
                if (data.length > 0) {
                    data.forEach(sub => {
                        let opt = document.createElement("option");
                        opt.value = sub.SUBJECT_ID;
                        opt.textContent = `${sub.SUBJECT_CODE} - ${sub.DESCRIPTION}`;
                        subjectSelect.appendChild(opt);
                    });
                    subjectSelect.disabled = false;
                }
            })
            .catch(err => console.error("Fetch error:", err));
    }
});
</script>
    <script>
        var slideIndex = 0;
        showSlides();

        function showSlides() {
            var i;
            var slides = document.getElementsByClassName("mySlides");
            var dots = document.getElementsByClassName("dot");
            for (i = 0; i < slides.length; i++) {
                slides[i].style.display = "none";
            }
            slideIndex++;
            if (slideIndex > slides.length) { slideIndex = 1 }
            for (i = 0; i < dots.length; i++) {
                dots[i].className = dots[i].className.replace(" active", "");
            }
            slides[slideIndex - 1].style.display = "block";
            dots[slideIndex - 1].className += " active";
            setTimeout(showSlides, 5000); // Change image every 2 seconds
        }
    </script>
    <script src="assets/js/ie10-viewport-bug-workaround.js"></script>
    <?php include('includes/javascripts.php'); ?>
</body>
</html>
<?php } else {
    header('location:section.php');

} ?>