<style>
    .alert-success {
        background-color: #96DB6B;
        color: #fff;
        padding: 15px;
        width: 70%;
        border-radius: 5px;
        z-index: 1000;
        position: fixed;
    }
</style>

<?php
include 'db.php'; // Make sure session is started

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['btn_add'])) {
        $prev = $_SERVER['HTTP_REFERER'] ?? 'section.php'; 
        $errors = [];

        // Validate inputs
        if (empty($_POST['subject'])) $errors['subject'] = "* Subject is required.";
        if (empty($_POST['faculty'])) $errors['faculty'] = "* Faculty is required.";
        if (empty($_POST['section'])) $errors['section'] = "* Section is required.";
        if (empty($_POST['ctime'])) $errors['ctime'] = "* Class time is required.";
        if (empty($_POST['cday'])) $errors['cday'] = "* Class day is required.";

        if (count($errors) === 0) {
            $sub = $_POST['subject'];
            $faculty = $_POST['faculty'];
            $section = $_POST['section'];
            $ctime = $_POST['ctime'];
            $cday = $_POST['cday'];
            $user = $_SESSION['ID'];

            // Get subject info
            $stmt = $conn->prepare("SELECT SUBJECT_CODE, DESCRIPTION, UNITS FROM subjects WHERE SUBJECT_ID = ?");
            $stmt->bind_param("i", $sub);
            $stmt->execute();
            $stmt->bind_result($subject_name, $description, $units);
            $stmt->fetch();
            $stmt->close();

            $subject_name = $subject_name ?: 'Unknown';
            $description = $description ?: 'Unknown';
            $units = $units ?: 'Unknown';

            // Get section info and GSID
            $stmt = $conn->prepare("SELECT GSID, SCHOOL_YEAR, YEAR_SECTION, SEMESTER FROM section WHERE SECTION_ID = ?");
            $stmt->bind_param("i", $section);
            $stmt->execute();
            $stmt->bind_result($gsid, $sy, $ys, $sem);
            $stmt->fetch();
            $stmt->close();

            $gsid = $gsid ?: 'Unknown';
            $sy = $sy ?: 'Unknown';
            $ys = $ys ?: 'Unknown';
            $semester = $sem.' Semester' ?: 'Unknown';

            // Get faculty name
            $stmt = $conn->prepare("SELECT LASTNAME, FIRSTNAME FROM user WHERE USER_ID = ?");
            $stmt->bind_param("i", $faculty);
            $stmt->execute();
            $stmt->bind_result($lname, $fname);
            $stmt->fetch();
            $stmt->close();

            $instructor = trim("$fname $lname") ?: 'Unknown';

            // Check if class already exists
            $class_check = $conn->prepare("SELECT CLASS_ID FROM classes WHERE SUBJECT_ID = ? AND SECTION_ID = ?");
            $class_check->bind_param("ii", $sub, $section);
            $class_check->execute();
            $class_check->store_result();

            if ($class_check->num_rows === 0) {
                // Insert new class
                $stmt = $conn->prepare("INSERT INTO classes (SUBJECT_ID, FACULTY_ID, SECTION_ID, CTIME, CDAY) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("iiiss", $sub, $faculty, $section, $ctime, $cday);
                $stmt->execute();
                $classId = $stmt->insert_id;
                $stmt->close();

                // Copy Google Sheet tab and get sheetId
                $sourceSheetName = 'Template(do not modify)';
                require_once 'gs_copy_sheet_tab.php';
                try {
                    $copyResult = copySheetTab($gsid, $sourceSheetName, $subject_name);

                    if (isset($copyResult['error'])) {
                        // Delete class if sheet copy failed
                        $del = $conn->prepare("DELETE FROM classes WHERE CLASS_ID = ?");
                        $del->bind_param("i", $classId);
                        $del->execute();
                        $del->close();
                        throw new Exception($copyResult['error']);
                    }

                    $sheetTabId = $copyResult['sheetId'];

                    // Update classes table with SHEET_TAB_ID
                    $stmt = $conn->prepare("UPDATE classes SET SHEET_TAB_ID = ? WHERE CLASS_ID = ?");
                    $stmt->bind_param("si", $sheetTabId, $classId);
                    $stmt->execute();
                    $stmt->close();

                    // Update sheet values
                    $updates = [
                        "{$subject_name}!AB6" => [ [ $units ] ],
                        "{$subject_name}!AA5:AD5" => [ [ $sy ] ],
                        "{$subject_name}!A7:E7" => [ [ $semester ] ],
                        "{$subject_name}!J7:M7" => [ [ $ys ] ],
                        "{$subject_name}!R7:V7" => [ [ $instructor ] ],
                        "{$subject_name}!Y7:AD7" => [ [ $description ] ],
                    ];

                    require_once 'gs_modify_specific_cell.php';
                    batchUpdateSheetValues($gsid, $updates);

                    // Log history
                    $log = $conn->prepare("INSERT INTO history_log (transaction, user_id, date_added) VALUES (?, ?, NOW())");
                    $transaction = "Added subject $sub to classes";
                    $log->bind_param("si", $transaction, $user);
                    $log->execute();
                    $log->close();

                    $alert = "<script>
                        document.addEventListener('DOMContentLoaded', function() {
                            showAlert('success', 'Succeed!', 'Added successfully.');
                            setTimeout(() => window.location.href = '$prev', 2000);
                        });
                    </script>";

                } catch (Exception $e) {
                    die("Google API Error: " . $e->getMessage());
                }

            } else {
                $alert = "<script>
                    showAlert('error', 'Oh no!', 'Class already exists.');
                    setTimeout(() => window.location.href = '$prev', 4000);
                </script>";
            }

            $class_check->close();

        } else {
            echo "<script>setTimeout(function(){ $('.erlert').hide(); }, 3000);</script>";
        }
    }
}

mysqli_close($conn);
?>
