<?php
if (!function_exists('calc_grade')) {
    function calc_grade($grade) {
        // Treat empty, 0, or "-" as INC
        if ($grade === "-" || $grade == 0) {
            return "INC";
        }
        if ($grade === "") {
            return "";
        }

        $grade = round(floatval($grade)); // Round to nearest integer

        // Apply the grading scale
        if ($grade >= 99) return number_format(1.00, 2);
        if ($grade == 98) return number_format(1.10, 2);
        if ($grade == 97) return number_format(1.20, 2);
        if ($grade == 96) return number_format(1.25, 2);
        if ($grade == 95) return number_format(1.30, 2);
        if ($grade == 94) return number_format(1.40, 2);
        if ($grade == 93) return number_format(1.50, 2);
        if ($grade == 92) return number_format(1.60, 2);
        if ($grade == 91) return number_format(1.70, 2);
        if ($grade == 90) return number_format(1.75, 2);
        if ($grade == 89) return number_format(1.80, 2);
        if ($grade == 88) return number_format(1.90, 2);
        if ($grade == 87) return number_format(2.00, 2);
        if ($grade == 86) return number_format(2.10, 2);
        if ($grade == 85) return number_format(2.20, 2);
        if ($grade == 84) return number_format(2.25, 2);
        if ($grade == 83) return number_format(2.30, 2);
        if ($grade == 82) return number_format(2.40, 2);
        if ($grade == 81) return number_format(2.50, 2);
        if ($grade == 80) return number_format(2.60, 2);
        if ($grade == 79) return number_format(2.70, 2);
        if ($grade == 78) return number_format(2.75, 2);
        if ($grade == 77) return number_format(2.80, 2);
        if ($grade == 76) return number_format(2.90, 2);
        if ($grade == 75) return number_format(3.00, 2);

        // Below 75 → 5.00
        if ($grade < 75) return number_format(5.00, 2);

        // Fallback (shouldn't happen)
        return "INC";
    }
}
?>
