<?php
//require __DIR__ . '/google_client_helper.php';

function updateSheetValues($spreadsheetId, $sheetName, $cellRange, $values) {
    $client = getGoogleClient();
    $sheetsService = new Google_Service_Sheets($client);

    // Build range like "Sheet1!A1" or "MyTab!B2:C5"
    $fullRange = "{$sheetName}!{$cellRange}";

    $body = new Google_Service_Sheets_ValueRange([
        'range'  => $fullRange,
        'values' => $values
    ]);

    $params = ['valueInputOption' => 'USER_ENTERED'];

    try {
        $result = $sheetsService->spreadsheets_values->update(
            $spreadsheetId,
            $fullRange,
            $body,
            $params
        );
        echo "<script>alert('Exported!')</script>";
        return "✅ Updated " . $result->getUpdatedCells() . " cell(s) in {$sheetName}";
    } catch (Exception $e) {
        echo "<script>alert('Failed to Export!')</script>";
        return "⚠️ Google API error: " . $e->getMessage();
    }
}
// ---- Example: Get data from MySQL ----
/*$mysqli = new mysqli("localhost", "username", "password", "database");

if ($mysqli->connect_errno) {
    die("Failed to connect to MySQL: " . $mysqli->connect_error);
}

// Fetch data
$query = "SELECT id, name, score FROM students";
$result = $mysqli->query($query);

$data = [];

// Add header row first (optional)
$data[] = ["ID", "Name", "Score"];

while ($row = $result->fetch_assoc()) {
    $data[] = [$row['id'], $row['name'], $row['score']];
}

$result->free();
$mysqli->close();

$spreadsheetId = "YOUR_SPREADSHEET_ID";
$sheetName = "Students";   // the tab name you want to update
$cellRange = "A1";         // cell or range (e.g., A1:B2)
$values = [["Hello World"]];

echo updateSheetValues($spreadsheetId, $sheetName, $cellRange, $data);*/
?>